/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.CallableExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class InvokeExprAST
extends CallableExprAST {
    private final BinaryAST.NodeType nodeType;
    private MethodConstant method;
    private ExprAST target;

    InvokeExprAST(BinaryAST.NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public InvokeExprAST(MethodConstant method, TypeConstant[] retTypes, ExprAST target, ExprAST[] args, boolean async) {
        super(retTypes, args);
        assert (method != null && target != null);
        this.nodeType = async ? BinaryAST.NodeType.InvokeAsyncExpr : BinaryAST.NodeType.InvokeExpr;
        this.method = method;
        this.target = target;
    }

    public ExprAST getTarget() {
        return this.target;
    }

    public MethodConstant getMethod() {
        return this.method;
    }

    public boolean isAsync() {
        return this.nodeType == BinaryAST.NodeType.InvokeAsyncExpr;
    }

    @Override
    public boolean isConditional() {
        MethodStructure struct = (MethodStructure)this.method.getComponent();
        return struct.isConditionalReturn();
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return this.nodeType;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        super.readBody(in, res);
        this.method = (MethodConstant)res.getConstant(Handy.readMagnitude(in));
        this.target = InvokeExprAST.readExprAST(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        super.prepareWrite(res);
        this.method = (MethodConstant)res.register(this.method);
        this.target.prepareWrite(res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        super.writeBody(out, res);
        Handy.writePackedLong(out, res.indexOf(this.method));
        this.target.writeExpr(out, res);
    }

    @Override
    public String toString() {
        return this.target.toString() + "." + this.method.getName() + (this.isAsync() ? "^" : "") + super.toString();
    }
}

