/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BiExprAST;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class IsExprAST
extends BiExprAST {
    private TypeConstant typeOfType;
    private transient TypeConstant booleanType;

    IsExprAST() {
    }

    public IsExprAST(ExprAST expr1, ExprAST expr2, TypeConstant typeOfType) {
        super(expr1, BiExprAST.Operator.Is, expr2);
        this.typeOfType = typeOfType;
    }

    @Override
    public int getCount() {
        return 2;
    }

    @Override
    public TypeConstant getType(int i) {
        switch (i) {
            case 0: {
                return this.booleanType;
            }
            case 1: {
                if (this.typeOfType == null) break;
                return this.typeOfType;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.DivRemExpr;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        super.readBody(in, res);
        if (Handy.readMagnitude(in) != 0) {
            this.typeOfType = (TypeConstant)res.getConstant(Handy.readMagnitude(in));
        }
        this.booleanType = res.typeForName("Boolean");
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        super.prepareWrite(res);
        if (this.typeOfType != null) {
            this.typeOfType = (TypeConstant)res.register(this.typeOfType);
        }
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        super.writeBody(out, res);
        if (this.typeOfType == null) {
            Handy.writePackedLong(out, 0L);
        } else {
            Handy.writePackedLong(out, 1L);
            Handy.writePackedLong(out, res.indexOf(this.typeOfType));
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getExpr1()) + ".is(" + String.valueOf(this.getExpr2()) + ")";
    }
}

