/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class ListExprAST
extends ExprAST {
    private TypeConstant type;
    private ExprAST[] values;

    ListExprAST() {
    }

    public ListExprAST(TypeConstant type, ExprAST[] values) {
        assert (type != null);
        assert (values != null && Arrays.stream(values).allMatch(Objects::nonNull));
        this.type = type;
        this.values = values;
    }

    public ExprAST[] getValues() {
        return this.values;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.ListExpr;
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.type;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.type = (TypeConstant)res.getConstant(Handy.readMagnitude(in));
        this.values = ListExprAST.readExprArray(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        this.type = (TypeConstant)res.register(this.type);
        ListExprAST.prepareASTArray(this.values, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        Handy.writePackedLong(out, res.indexOf(this.type));
        ListExprAST.writeExprArray(this.values, out, res);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.type).append(":[");
        for (ExprAST value : this.values) {
            buf.append(value.toString()).append(", ");
        }
        buf.delete(buf.length() - 2, buf.length()).append(']');
        return buf.toString();
    }
}

