/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.RegAllocAST;
import org.xvm.util.Handy;

public class LoopStmtAST
extends BinaryAST {
    private ExprAST[] specialRegs;
    private BinaryAST body;

    LoopStmtAST() {
    }

    public LoopStmtAST(RegAllocAST[] specialRegs, BinaryAST body) {
        assert (body != null);
        this.specialRegs = specialRegs == null ? NO_ALLOCS : specialRegs;
        this.body = body;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.LoopStmt;
    }

    public BinaryAST getBody() {
        return this.body;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        res.enter();
        this.specialRegs = LoopStmtAST.readExprArray(in, res);
        this.body = LoopStmtAST.readAST(in, res);
        res.exit();
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        res.enter();
        LoopStmtAST.prepareASTArray(this.specialRegs, res);
        LoopStmtAST.prepareAST(this.body, res);
        res.exit();
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        LoopStmtAST.writeExprArray(this.specialRegs, out, res);
        LoopStmtAST.writeAST(this.body, out, res);
    }

    @Override
    public String toString() {
        return "while (True) {\n" + Handy.indentLines(this.body.toString(), "  ") + "\n}";
    }
}

