/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class MapExprAST
extends ExprAST {
    private TypeConstant type;
    private ExprAST[] keys;
    private ExprAST[] values;

    MapExprAST() {
    }

    public MapExprAST(TypeConstant type, ExprAST[] keys, ExprAST[] values) {
        assert (type != null);
        assert (keys != null && Arrays.stream(keys).allMatch(Objects::nonNull));
        assert (values != null && Arrays.stream(values).allMatch(Objects::nonNull));
        assert (keys.length == values.length);
        this.type = type;
        this.keys = keys;
        this.values = values;
    }

    public ExprAST[] getKeys() {
        return this.keys;
    }

    public ExprAST[] getValues() {
        return this.values;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.MapExpr;
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.type;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.type = (TypeConstant)res.getConstant(Handy.readMagnitude(in));
        this.keys = MapExprAST.readExprArray(in, res);
        this.values = MapExprAST.readExprArray(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        this.type = (TypeConstant)res.register(this.type);
        MapExprAST.prepareASTArray(this.keys, res);
        MapExprAST.prepareASTArray(this.values, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        Handy.writePackedLong(out, res.indexOf(this.type));
        MapExprAST.writeExprArray(this.keys, out, res);
        MapExprAST.writeExprArray(this.values, out, res);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.type).append(":[");
        int c = this.keys.length;
        for (int i = 0; i < c; ++i) {
            ExprAST key = this.keys[i];
            ExprAST value = this.values[i];
            buf.append(key.toString()).append("=").append(value.toString()).append(", ");
        }
        buf.append(']');
        return buf.toString();
    }
}

