/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;

public class MultiExprAST
extends ExprAST {
    private ExprAST[] exprs;

    MultiExprAST() {
    }

    public MultiExprAST(ExprAST[] exprs) {
        assert (exprs != null && Arrays.stream(exprs).allMatch(Objects::nonNull));
        this.exprs = exprs;
    }

    public ExprAST[] getExprs() {
        return this.exprs;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.MultiExpr;
    }

    @Override
    public int getCount() {
        return this.exprs.length;
    }

    @Override
    public TypeConstant getType(int i) {
        return this.exprs[i].getType(0);
    }

    @Override
    public boolean isAssignable() {
        return Arrays.stream(this.exprs).allMatch(ExprAST::isAssignable);
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.exprs = MultiExprAST.readExprArray(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        MultiExprAST.prepareASTArray(this.exprs, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        MultiExprAST.writeExprArray(this.exprs, out, res);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        for (ExprAST value : this.exprs) {
            buf.append(value.toString()).append(", ");
        }
        buf.append(')');
        return buf.toString();
    }
}

