/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.Constant;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class NewExprAST
extends ExprAST {
    private final BinaryAST.NodeType nodeType;
    private ExprAST parent;
    private TypeConstant type;
    private Constant constr;
    private ExprAST[] args;

    NewExprAST(BinaryAST.NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public NewExprAST(TypeConstant type, Constant constr, ExprAST[] args) {
        assert (type != null && constr != null);
        assert (args != null && Arrays.stream(args).allMatch(Objects::nonNull));
        this.type = type;
        this.constr = constr;
        this.args = args;
        this.nodeType = BinaryAST.NodeType.NewExpr;
    }

    public NewExprAST(ExprAST parent, TypeConstant type, Constant constr, ExprAST[] args) {
        assert (parent != null && type != null && constr != null);
        assert (args != null && Arrays.stream(args).allMatch(Objects::nonNull));
        this.parent = parent;
        this.type = type;
        this.constr = constr;
        this.args = args;
        this.nodeType = BinaryAST.NodeType.NewChildExpr;
    }

    public NewExprAST(ExprAST target, Constant constr, ExprAST[] args) {
        assert (target != null && constr != null);
        assert (args != null && Arrays.stream(args).allMatch(Objects::nonNull));
        this.parent = target;
        this.constr = constr;
        this.args = args;
        this.nodeType = BinaryAST.NodeType.NewVirtualExpr;
    }

    public Constant getType() {
        return this.type;
    }

    public Constant getConstructor() {
        return this.constr;
    }

    public ExprAST[] getArgs() {
        return this.args;
    }

    public boolean isVirtual() {
        return this.nodeType == BinaryAST.NodeType.NewVirtualExpr;
    }

    public boolean isChild() {
        return this.nodeType == BinaryAST.NodeType.NewChildExpr;
    }

    public ExprAST getParent() {
        return this.parent;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return this.nodeType;
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.nodeType == BinaryAST.NodeType.NewVirtualExpr ? this.parent.getType(0) : this.type;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        if (this.isChild() || this.isVirtual()) {
            this.parent = NewExprAST.readExprAST(in, res);
        }
        if (!this.isVirtual()) {
            this.type = (TypeConstant)res.getConstant(Handy.readMagnitude(in));
        }
        this.constr = res.getConstant(Handy.readMagnitude(in));
        this.args = NewExprAST.readExprArray(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        if (this.isChild()) {
            this.parent.prepareWrite(res);
        }
        if (!this.isVirtual()) {
            this.type = (TypeConstant)res.register(this.type);
        }
        this.constr = res.register(this.constr);
        NewExprAST.prepareASTArray(this.args, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        if (this.isChild() || this.isVirtual()) {
            this.parent.writeExpr(out, res);
        }
        if (!this.isVirtual()) {
            Handy.writePackedLong(out, res.indexOf(this.type));
        }
        Handy.writePackedLong(out, res.indexOf(this.constr));
        NewExprAST.writeExprArray(this.args, out, res);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.isChild() || this.isVirtual()) {
            buf.append(this.parent).append('.');
        }
        buf.append("new");
        if (!this.isVirtual()) {
            buf.append(' ').append(this.type.getValueString());
        }
        buf.append('(');
        int c = this.args.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.args[i]);
        }
        buf.append(')');
        return buf.toString();
    }
}

