/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.DelegatingExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;

public class OrderedExprAST
extends DelegatingExprAST {
    private final BinaryAST.NodeType nodeType;
    private final Operator op;
    private transient TypeConstant booleanType;

    OrderedExprAST(BinaryAST.NodeType nodeType) {
        this.op = switch (nodeType) {
            case BinaryAST.NodeType.Less -> Operator.Less;
            case BinaryAST.NodeType.Greater -> Operator.Greater;
            default -> throw new IllegalArgumentException("nodeType=" + String.valueOf((Object)nodeType));
        };
        this.nodeType = nodeType;
    }

    public OrderedExprAST(ExprAST expr, Operator op) {
        super(expr);
        this.op = op;
        this.nodeType = switch (op.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BinaryAST.NodeType.Less;
            case 1 -> BinaryAST.NodeType.Greater;
        };
    }

    public Operator getOp() {
        return this.op;
    }

    @Override
    public TypeConstant getType(int i) {
        return this.booleanType;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return this.nodeType;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        super.readBody(in, res);
        this.booleanType = res.typeForName("Boolean");
    }

    @Override
    public String toString() {
        return String.valueOf(this.getExpr()) + " == " + this.op.toString();
    }

    public static enum Operator {
        Less(BinaryAST.NodeType.Less),
        Greater(BinaryAST.NodeType.Greater);

        public final BinaryAST.NodeType nodeType;

        private Operator(BinaryAST.NodeType nodeType) {
            this.nodeType = nodeType;
        }
    }
}

