/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.UnaryExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class OuterExprAST
extends UnaryExprAST {
    private int depth;

    OuterExprAST() {
    }

    public OuterExprAST(ExprAST expr, int depth, TypeConstant type) {
        super(expr, type);
        assert (depth > 0);
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.OuterExpr;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        super.readBody(in, res);
        this.depth = Handy.readMagnitude(in);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        super.writeBody(out, res);
        Handy.writePackedLong(out, this.depth);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getExpr()) + ".outer".repeat(Math.max(0, this.depth));
    }
}

