/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.DelegatingExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class PropertyExprAST
extends DelegatingExprAST {
    private Constant property;

    PropertyExprAST() {
    }

    public PropertyExprAST(ExprAST expr, Constant property) {
        super(expr);
        assert (property != null);
        this.property = property;
    }

    public ExprAST getTarget() {
        return this.getExpr();
    }

    public Constant getProperty() {
        return this.property;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.PropertyExpr;
    }

    @Override
    public TypeConstant getType(int i) {
        TypeConstant typeResolved;
        assert (i == 0);
        TypeConstant typeProp = this.property.getType();
        if (typeProp.isFormalType() && (typeResolved = this.getExpr().getType(0).resolveFormalType((FormalConstant)typeProp.getDefiningConstant())) != null) {
            return typeResolved;
        }
        return typeProp;
    }

    @Override
    public boolean isAssignable() {
        return true;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        super.readBody(in, res);
        this.property = res.getConstant(Handy.readMagnitude(in));
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        super.prepareWrite(res);
        this.property = res.register(this.property);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        super.writeBody(out, res);
        Handy.writePackedLong(out, res.indexOf(this.property));
    }

    @Override
    public String toString() {
        return this.getTarget().toString() + "." + this.property.getValueString();
    }
}

