/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.RegisterAST;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class RegAllocAST
extends ExprAST {
    private final BinaryAST.NodeType nodeType;
    private transient RegisterAST reg;

    RegAllocAST(BinaryAST.NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public RegAllocAST(TypeConstant type, StringConstant name) {
        assert (type != null);
        this.reg = new RegisterAST(type, name);
        this.nodeType = name == null ? BinaryAST.NodeType.RegAlloc : BinaryAST.NodeType.NamedRegAlloc;
    }

    public RegAllocAST(TypeConstant refType, TypeConstant type, StringConstant name) {
        assert (refType != null && type != null);
        this.reg = new RegisterAST(refType, type, name);
        this.nodeType = name == null ? BinaryAST.NodeType.AnnoRegAlloc : BinaryAST.NodeType.AnnoNamedRegAlloc;
    }

    public RegisterAST getRegister() {
        return this.reg;
    }

    public Constant getRefType() {
        return this.reg.getRefType();
    }

    public String getName() {
        return this.reg.getName();
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.reg.getType(0);
    }

    @Override
    public boolean isAssignable() {
        return true;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return this.nodeType;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        TypeConstant refType = null;
        if (this.nodeType == BinaryAST.NodeType.AnnoRegAlloc || this.nodeType == BinaryAST.NodeType.AnnoNamedRegAlloc) {
            refType = (TypeConstant)res.getConstant(Handy.readPackedInt(in));
        }
        TypeConstant type = (TypeConstant)res.getConstant(Handy.readPackedInt(in));
        StringConstant name = null;
        if (this.nodeType == BinaryAST.NodeType.NamedRegAlloc || this.nodeType == BinaryAST.NodeType.AnnoNamedRegAlloc) {
            name = (StringConstant)res.getConstant(Handy.readPackedInt(in));
        }
        this.reg = refType == null ? new RegisterAST(type, name) : new RegisterAST(refType, type, name);
        res.register(this.reg);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        this.reg.refType = (TypeConstant)res.register(this.reg.refType);
        this.reg.type = (TypeConstant)res.register(this.reg.type);
        this.reg.name = (StringConstant)res.register(this.reg.name);
        res.register(this.reg);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        if (this.nodeType == BinaryAST.NodeType.AnnoRegAlloc || this.nodeType == BinaryAST.NodeType.AnnoNamedRegAlloc) {
            Handy.writePackedLong(out, res.indexOf(this.reg.refType));
        }
        Handy.writePackedLong(out, res.indexOf(this.reg.type));
        if (this.nodeType == BinaryAST.NodeType.NamedRegAlloc || this.nodeType == BinaryAST.NodeType.AnnoNamedRegAlloc) {
            Handy.writePackedLong(out, res.indexOf(this.reg.name));
        }
    }

    @Override
    public String toString() {
        TypeConstant typeRef = this.reg.getRefType();
        TypeConstant type = this.reg.getType();
        StringBuilder buf = new StringBuilder();
        if (typeRef != null) {
            buf.append(typeRef.getValueString()).append(' ');
        }
        buf.append(type.getValueString()).append(' ').append(this.reg);
        return buf.toString();
    }
}

