/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class RegisterAST
extends ExprAST {
    private static final int UNASSIGNED_ID = Integer.MAX_VALUE;
    private int regId = Integer.MAX_VALUE;
    transient TypeConstant refType;
    transient TypeConstant type;
    transient StringConstant name;

    public RegisterAST(TypeConstant type, StringConstant name) {
        assert (type != null);
        this.type = type;
        this.name = name;
    }

    public RegisterAST(TypeConstant refType, TypeConstant type, StringConstant name) {
        this(type, name);
        assert (refType != null);
        this.refType = refType;
    }

    public RegisterAST(int regId, TypeConstant type, StringConstant name) {
        assert (regId > -16 && regId < 0);
        assert (regId != -1);
        this.regId = regId;
        this.type = type;
        this.name = name;
    }

    public int getRegId() {
        return this.regId;
    }

    public boolean isRegIdSpecial() {
        return this.regId < 0;
    }

    public boolean isRegIdAssigned() {
        return this.regId != Integer.MAX_VALUE;
    }

    public boolean isAnnotated() {
        return this.refType != null;
    }

    public TypeConstant getRefType() {
        return this.refType;
    }

    public void setRegId(int regId) {
        assert (regId >= 0 && this.regId >= 0);
        this.regId = regId;
    }

    public TypeConstant getType() {
        return this.type;
    }

    public StringConstant getNameConstant() {
        return this.name;
    }

    public String getName() {
        return this.name.getValue();
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.type;
    }

    @Override
    public boolean isAssignable() {
        return !this.isRegIdSpecial() || this.getRegId() == -2 || this.getRegId() == -3;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.RegisterExpr;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        throw new IllegalStateException("Use 'readExpr' instead");
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        throw new IllegalStateException("Use 'writeExpr' instead");
    }

    @Override
    protected void writeExpr(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        assert (this.regId != Integer.MAX_VALUE);
        assert (this.regId != -1);
        Handy.writePackedLong(out, this.regId < 0 ? (long)this.regId : (long)(32 + this.regId));
    }

    public static RegisterAST defaultReg(TypeConstant type) {
        return new RegisterAST(-4, type, null);
    }

    @Override
    public String toString() {
        if (this.name != null) {
            return this.name.getValue();
        }
        return switch (this.regId) {
            case -9, -8, -7, -6, -5 -> "this";
            case -10 -> "this:struct";
            case -11 -> "this:class";
            case -12 -> "this:service";
            case -13 -> "super";
            default -> this.regId == Integer.MAX_VALUE ? "_" : "_#" + this.regId;
        };
    }
}

