/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;

public class ReturnStmtAST
extends BinaryAST {
    private final BinaryAST.NodeType nodeType;
    private ExprAST[] exprs;

    ReturnStmtAST(BinaryAST.NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public ReturnStmtAST(ExprAST expr) {
        this(new ExprAST[]{expr});
    }

    public ReturnStmtAST(ExprAST[] exprs) {
        assert (Arrays.stream(exprs).allMatch(Objects::nonNull));
        this.exprs = exprs;
        this.nodeType = switch (exprs.length) {
            case 0 -> BinaryAST.NodeType.Return0Stmt;
            case 1 -> BinaryAST.NodeType.Return1Stmt;
            default -> BinaryAST.NodeType.ReturnNStmt;
        };
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return this.nodeType;
    }

    public ExprAST[] getExprs() {
        return this.exprs;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        switch (this.nodeType) {
            case Return0Stmt: {
                this.exprs = NO_EXPRS;
                break;
            }
            case Return1Stmt: {
                ExprAST expr = ReturnStmtAST.readExprAST(in, res);
                assert (expr != null);
                this.exprs = new ExprAST[]{expr};
                break;
            }
            case ReturnNStmt: {
                this.exprs = ReturnStmtAST.readExprArray(in, res);
                break;
            }
            default: {
                throw new IllegalStateException("nodeType=" + String.valueOf((Object)this.nodeType));
            }
        }
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        ReturnStmtAST.prepareASTArray(this.exprs, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        switch (this.nodeType) {
            case Return0Stmt: {
                break;
            }
            case Return1Stmt: {
                this.exprs[0].writeExpr(out, res);
                break;
            }
            case ReturnNStmt: {
                ReturnStmtAST.writeExprArray(this.exprs, out, res);
                break;
            }
            default: {
                throw new IllegalStateException("nodeType=" + String.valueOf((Object)this.nodeType));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("return");
        int c = this.exprs.length;
        for (int i = 0; i < c; ++i) {
            buf.append(i == 0 ? " " : ", ").append(this.exprs[i].toString());
        }
        return buf.append(";").toString();
    }
}

