/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.util.Handy;

public class StmtBlockAST
extends BinaryAST {
    private BinaryAST[] stmts;
    private final boolean hasScope;
    public static StmtBlockAST EMPTY = new StmtBlockAST(NO_ASTS, true);

    StmtBlockAST(BinaryAST.NodeType nodeType) {
        this.hasScope = switch (nodeType) {
            case BinaryAST.NodeType.StmtBlock -> true;
            case BinaryAST.NodeType.MultiStmt -> false;
            default -> throw new IllegalArgumentException("nodeType=" + String.valueOf((Object)nodeType));
        };
    }

    public StmtBlockAST(BinaryAST[] stmts, Boolean hasScope) {
        assert (stmts != null && Arrays.stream(stmts).allMatch(Objects::nonNull));
        this.stmts = stmts;
        this.hasScope = hasScope != false && stmts.length > 0;
    }

    public boolean hasScope() {
        return this.hasScope;
    }

    public BinaryAST[] getStmts() {
        return this.stmts;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return this.hasScope ? BinaryAST.NodeType.StmtBlock : BinaryAST.NodeType.MultiStmt;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        if (this.hasScope) {
            res.enter();
            this.stmts = StmtBlockAST.readASTArray(in, res);
            res.exit();
        } else {
            this.stmts = StmtBlockAST.readASTArray(in, res);
        }
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        if (this.hasScope) {
            res.enter();
            StmtBlockAST.prepareASTArray(this.stmts, res);
            res.exit();
        } else {
            StmtBlockAST.prepareASTArray(this.stmts, res);
        }
    }

    @Override
    public void write(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        if (this.stmts.length == 0) {
            out.writeByte(BinaryAST.NodeType.None.ordinal());
        } else {
            super.write(out, res);
        }
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        StmtBlockAST.writeASTArray(this.stmts, out, res);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        int c = this.stmts.length;
        for (int i = 0; i < c; ++i) {
            BinaryAST stmt = this.stmts[i];
            if (i > 0) {
                buf.append('\n');
            }
            buf.append(Handy.indentLines(stmt.toString(), "  "));
        }
        return buf.toString();
    }
}

