/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class StmtExprAST
extends ExprAST {
    private BinaryAST stmt;
    private TypeConstant[] types;

    StmtExprAST() {
    }

    public StmtExprAST(BinaryAST stmt, TypeConstant[] types) {
        assert (stmt != null);
        assert (types != null && Arrays.stream(types).allMatch(Objects::nonNull));
        this.stmt = stmt;
        this.types = types;
    }

    public BinaryAST getStatement() {
        return this.stmt;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.StmtExpr;
    }

    @Override
    public TypeConstant getType(int i) {
        return this.types[i];
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.stmt = StmtExprAST.readAST(in, res);
        this.types = StmtExprAST.readTypeArray(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        this.stmt.prepareWrite(res);
        StmtExprAST.prepareConstArray(this.types, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        this.stmt.write(out, res);
        StmtExprAST.writeConstArray(this.types, out, res);
    }

    @Override
    public String toString() {
        String text = this.stmt.toString();
        return text.indexOf(10) < 0 ? "{" + text + "}" : "{\n" + Handy.indentLines(text, "  ") + "\n}";
    }
}

