/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.xvm.asm.Constant;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.MultiExprAST;
import org.xvm.asm.ast.TernaryExprAST;
import org.xvm.asm.ast.ThrowExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;
import org.xvm.util.PackedInteger;

public class SwitchAST
extends ExprAST {
    private ExprAST cond;
    private long isaTest;
    private Constant[] cases;
    private BinaryAST[] bodies;
    private TypeConstant[] resultTypes;

    SwitchAST(BinaryAST.NodeType nodeType) {
        this.resultTypes = nodeType == BinaryAST.NodeType.SwitchExpr ? NO_TYPES : null;
    }

    public SwitchAST(ExprAST cond, long isaTest, Constant[] cases, BinaryAST[] bodies) {
        this(cond, isaTest, cases, bodies, null);
    }

    public SwitchAST(ExprAST cond, long isaTest, Constant[] cases, BinaryAST[] bodies, TypeConstant[] resultTypes) {
        assert (cond != null && cond.getCount() > 0);
        assert (isaTest == 0L || Long.numberOfTrailingZeros(Long.highestOneBit(isaTest)) <= cond.getCount());
        assert (cases != null && Arrays.stream(cases).filter(Objects::nonNull).count() + 1L >= (long)cases.length);
        int rowCount = cases.length;
        assert (bodies != null && bodies.length <= rowCount);
        if (bodies.length < rowCount) {
            BinaryAST[] newBodies = new BinaryAST[rowCount];
            System.arraycopy(bodies, 0, newBodies, 0, bodies.length);
            bodies = newBodies;
        }
        if (resultTypes != null) {
            assert (resultTypes.length > 0 && Arrays.stream(resultTypes).allMatch(Objects::nonNull));
            int resultCount = resultTypes.length;
            for (BinaryAST body : bodies) {
                if (body instanceof ExprAST) {
                    ExprAST expr = (ExprAST)body;
                    assert (expr.getCount() >= resultCount || expr instanceof ThrowExprAST || expr.getCount() == 1 && expr instanceof ConstantExprAST || expr instanceof TernaryExprAST);
                    continue;
                }
                assert (body == null);
            }
        }
        this.cond = cond;
        this.isaTest = isaTest;
        this.cases = cases;
        this.bodies = bodies;
        this.resultTypes = resultTypes;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return this.resultTypes == null ? BinaryAST.NodeType.SwitchStmt : BinaryAST.NodeType.SwitchExpr;
    }

    public ExprAST getCondition() {
        return this.cond;
    }

    public long isIsTypeTest() {
        return this.isaTest;
    }

    public boolean isIsTypeTest(int column) {
        assert (column >= 0 && column < 64);
        return (this.isaTest & 1L << column) != 0L;
    }

    public Constant[] getCases() {
        return this.cases;
    }

    public BinaryAST[] getBodies() {
        return this.bodies;
    }

    public Iterator contents() {
        return new Iterator(){
            int cur = 0;
            boolean checkBody = false;
            Object loaded = null;

            @Override
            public boolean hasNext() {
                if (this.loaded != null) {
                    return true;
                }
                if (this.checkBody) {
                    this.loaded = SwitchAST.this.bodies[this.cur];
                    ++this.cur;
                    this.checkBody = false;
                    if (this.loaded != null) {
                        return true;
                    }
                }
                if (this.cur < SwitchAST.this.cases.length) {
                    this.loaded = SwitchAST.this.cases[this.cur];
                    this.checkBody = true;
                    return true;
                }
                return false;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object value = this.loaded;
                this.loaded = null;
                return value;
            }
        };
    }

    @Override
    public int getCount() {
        return this.resultTypes.length;
    }

    @Override
    public TypeConstant getType(int i) {
        return this.resultTypes[i];
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        boolean isExpr;
        res.enter();
        this.cond = SwitchAST.readExprAST(in, res);
        this.isaTest = Handy.readPackedLong(in);
        int rowCount = Handy.readMagnitude(in);
        if (rowCount == 0) {
            this.cases = NO_CONSTS;
        } else {
            this.cases = new Constant[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                int id = (int)Handy.readPackedLong(in);
                this.cases[i] = id >= 0 ? res.getConstant(id) : null;
            }
        }
        assert (this.isaTest == 0L || Long.numberOfTrailingZeros(Long.highestOneBit(this.isaTest)) < this.cond.getCount());
        this.bodies = new BinaryAST[rowCount];
        boolean bl = isExpr = this.nodeType() == BinaryAST.NodeType.SwitchExpr;
        if (rowCount < 64) {
            long hasBody = Handy.readPackedLong(in);
            for (int i = 0; i < rowCount; ++i) {
                if ((hasBody & 1L << i) == 0L) continue;
                res.enter();
                this.bodies[i] = isExpr ? SwitchAST.readExprAST(in, res) : SwitchAST.readAST(in, res);
                res.exit();
            }
        } else {
            PackedInteger hasBody = new PackedInteger(in);
            int i = 0;
            while (hasBody.cmp(PackedInteger.ZERO) != 0) {
                if (hasBody.and(PackedInteger.ONE).cmp(PackedInteger.ZERO) != 0) {
                    res.enter();
                    this.bodies[i] = isExpr ? SwitchAST.readExprAST(in, res) : SwitchAST.readAST(in, res);
                    res.exit();
                }
                hasBody = hasBody.ushr(1);
                ++i;
            }
        }
        res.exit();
        if (this.nodeType() == BinaryAST.NodeType.SwitchExpr) {
            this.resultTypes = SwitchAST.readTypeArray(in, res);
        }
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        res.enter();
        SwitchAST.prepareAST(this.cond, res);
        SwitchAST.prepareConstArray(this.cases, res);
        for (BinaryAST body : this.bodies) {
            res.enter();
            SwitchAST.prepareAST(body, res);
            res.exit();
        }
        res.exit();
        SwitchAST.prepareConstArray(this.resultTypes, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        this.cond.writeExpr(out, res);
        Handy.writePackedLong(out, this.isaTest);
        int count = this.cases.length;
        Handy.writePackedLong(out, count);
        for (int i = 0; i < count; ++i) {
            Constant value = this.cases[i];
            Handy.writePackedLong(out, value == null ? -1L : (long)res.indexOf(value));
        }
        int rowCount = this.cases.length;
        int check = 0;
        if (rowCount < 64) {
            long bits = 0L;
            for (int row = 0; row < rowCount; ++row) {
                if (this.bodies[row] == null) continue;
                bits |= 1L << row;
                ++check;
            }
            Handy.writePackedLong(out, bits);
        } else {
            PackedInteger bits = PackedInteger.ZERO;
            for (int row = 0; row < rowCount; ++row) {
                if (this.bodies[row] == null) continue;
                bits = bits.or(PackedInteger.ONE.shl(row));
                ++check;
            }
            bits.writeObject(out);
        }
        if (this.nodeType() == BinaryAST.NodeType.SwitchExpr) {
            for (BinaryAST body : this.bodies) {
                if (body == null) continue;
                SwitchAST.writeExprAST((ExprAST)body, out, res);
                --check;
            }
            SwitchAST.writeConstArray(this.resultTypes, out, res);
        } else {
            for (BinaryAST body : this.bodies) {
                if (body == null) continue;
                SwitchAST.writeAST(body, out, res);
                --check;
            }
        }
        assert (check == 0);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("switch (");
        ExprAST exprAST = this.cond;
        if (exprAST instanceof MultiExprAST) {
            ExprAST[] exprs;
            MultiExprAST meAst = (MultiExprAST)exprAST;
            for (ExprAST expr : exprs = meAst.getExprs()) {
                buf.append(expr);
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
        } else {
            buf.append(this.cond);
        }
        buf.append(") {");
        int rowCount = this.cases.length;
        for (int row = 0; row < rowCount; ++row) {
            buf.append("\ncase ");
            buf.append(this.cases[row]);
            buf.append(":");
            BinaryAST body = this.bodies[row];
            if (body == null) continue;
            String text = body.toString();
            if (text.indexOf(10) < 0) {
                buf.append(' ').append(text);
                continue;
            }
            buf.append('\n').append(Handy.indentLines(text, "  "));
        }
        buf.append("\n}");
        return buf.toString();
    }
}

