/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;

public class TemplateExprAST
extends ExprAST {
    private ExprAST[] exprs;
    private transient TypeConstant typeString;

    TemplateExprAST() {
    }

    public TemplateExprAST(ExprAST[] exprs) {
        assert (exprs != null && Arrays.stream(exprs).allMatch(Objects::nonNull));
        this.exprs = exprs;
    }

    public ExprAST[] getExprs() {
        return this.exprs;
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.typeString;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.TemplateExpr;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.exprs = TemplateExprAST.readExprArray(in, res);
        this.typeString = res.typeForName("String");
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        TemplateExprAST.prepareASTArray(this.exprs, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        TemplateExprAST.writeExprArray(this.exprs, out, res);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.exprs[0]);
        int c = this.exprs.length;
        for (int i = 1; i < c; ++i) {
            buf.append(" + ").append(this.exprs[i]);
        }
        return buf.toString();
    }
}

