/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;

public class TernaryExprAST
extends ExprAST {
    private ExprAST cond;
    private ExprAST exprThen;
    private ExprAST exprElse;
    private TypeConstant[] types;

    TernaryExprAST() {
    }

    public TernaryExprAST(ExprAST cond, ExprAST exprThen, ExprAST exprElse, TypeConstant[] types) {
        assert (cond != null && exprThen != null && exprElse != null && types != null && types.length > 0);
        this.cond = cond;
        this.exprThen = exprThen;
        this.exprElse = exprElse;
        this.types = types;
    }

    public ExprAST getCond() {
        return this.cond;
    }

    public ExprAST getThen() {
        return this.exprThen;
    }

    public ExprAST getElse() {
        return this.exprElse;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.TernaryExpr;
    }

    @Override
    public int getCount() {
        return Math.max(this.exprThen.getCount(), this.exprElse.getCount());
    }

    @Override
    public TypeConstant getType(int i) {
        return this.types[i];
    }

    @Override
    public boolean isAssignable() {
        return this.exprThen.isAssignable() && this.exprElse.isAssignable();
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.cond = TernaryExprAST.readExprAST(in, res);
        this.exprThen = TernaryExprAST.readExprAST(in, res);
        this.exprElse = TernaryExprAST.readExprAST(in, res);
        this.types = TernaryExprAST.readTypeArray(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        this.cond.prepareWrite(res);
        this.exprThen.prepareWrite(res);
        this.exprElse.prepareWrite(res);
        TernaryExprAST.prepareConstArray(this.types, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        this.cond.writeExpr(out, res);
        this.exprThen.writeExpr(out, res);
        this.exprElse.writeExpr(out, res);
        TernaryExprAST.writeConstArray(this.types, out, res);
    }

    @Override
    public String toString() {
        return String.valueOf(this.cond) + " ? " + String.valueOf(this.exprThen) + " : " + String.valueOf(this.exprElse);
    }
}

