/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class ThrowExprAST
extends ExprAST {
    private ExprAST throwable;
    private ExprAST message;
    private transient TypeConstant type;

    ThrowExprAST() {
    }

    public ThrowExprAST(TypeConstant type, ExprAST throwable, ExprAST message) {
        assert (type != null && throwable != null);
        this.type = type;
        this.throwable = throwable;
        this.message = message;
    }

    public ExprAST getThrowable() {
        return this.throwable;
    }

    public ExprAST getMessage() {
        return this.message;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.ThrowExpr;
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.type;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.type = res.typeForName("Object");
        this.throwable = ThrowExprAST.readExprAST(in, res);
        if (Handy.readMagnitude(in) > 0) {
            this.message = ThrowExprAST.readExprAST(in, res);
        }
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        this.throwable.prepareWrite(res);
        if (this.message != null) {
            this.message.prepareWrite(res);
        }
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        this.throwable.writeExpr(out, res);
        if (this.message == null) {
            Handy.writePackedLong(out, 0L);
        } else {
            Handy.writePackedLong(out, 1L);
            this.message.writeExpr(out, res);
        }
    }

    @Override
    public String toString() {
        return "throw " + String.valueOf(this.throwable) + (String)(this.message == null ? "" : " (" + String.valueOf(this.message) + ")");
    }
}

