/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.util.Handy;

public class TryCatchStmtAST
extends BinaryAST {
    private ExprAST[] resources;
    private BinaryAST body;
    private BinaryAST[] catches;

    TryCatchStmtAST() {
    }

    public TryCatchStmtAST(ExprAST[] resources, BinaryAST body, BinaryAST[] catches) {
        assert (resources == null || Arrays.stream(resources).allMatch(Objects::nonNull));
        assert (body != null);
        assert (catches == null || Arrays.stream(catches).allMatch(Objects::nonNull));
        this.resources = resources == null ? NO_EXPRS : resources;
        this.body = body;
        this.catches = catches == null ? NO_ASTS : catches;
    }

    public BinaryAST[] getResources() {
        return this.resources;
    }

    public BinaryAST getBody() {
        return this.body;
    }

    public BinaryAST[] getCatches() {
        return this.catches;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.TryCatchStmt;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        this.resources = TryCatchStmtAST.readExprArray(in, res);
        this.body = TryCatchStmtAST.readAST(in, res);
        this.catches = TryCatchStmtAST.readASTArray(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        TryCatchStmtAST.prepareASTArray(this.resources, res);
        this.body.prepareWrite(res);
        TryCatchStmtAST.prepareASTArray(this.catches, res);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        TryCatchStmtAST.writeExprArray(this.resources, out, res);
        this.body.write(out, res);
        TryCatchStmtAST.writeASTArray(this.catches, out, res);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("try");
        if (this.resources.length > 0) {
            buf.append(" (");
            int c = this.resources.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.resources[i]);
            }
            buf.append(')');
        }
        buf.append(" {\n").append(Handy.indentLines(this.body.toString(), "  ")).append("\n}");
        for (BinaryAST catch_ : this.catches) {
            buf.append(" catch (???) {\n").append(Handy.indentLines(catch_.toString(), "  ")).append("\n}");
        }
        return buf.toString();
    }
}

