/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.RegAllocAST;
import org.xvm.asm.ast.TryCatchStmtAST;
import org.xvm.util.Handy;

public class TryFinallyStmtAST
extends TryCatchStmtAST {
    private RegAllocAST exception;
    private BinaryAST catchAll;

    TryFinallyStmtAST() {
    }

    public TryFinallyStmtAST(ExprAST[] resources, BinaryAST body, BinaryAST[] catches, RegAllocAST exception, BinaryAST catchAll) {
        super(resources, body, catches);
        assert (catchAll != null);
        this.exception = exception;
        this.catchAll = catchAll;
    }

    public RegAllocAST getException() {
        return this.exception;
    }

    public BinaryAST getCatchAll() {
        return this.catchAll;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.TryFinallyStmt;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        super.readBody(in, res);
        if (Handy.readPackedInt(in) != 0) {
            this.exception = (RegAllocAST)TryFinallyStmtAST.readExprAST(in, res);
        }
        this.catchAll = TryFinallyStmtAST.readAST(in, res);
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        super.prepareWrite(res);
        res.enter();
        if (this.exception != null) {
            this.exception.prepareWrite(res);
        }
        this.catchAll.prepareWrite(res);
        res.exit();
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        super.writeBody(out, res);
        res.enter();
        if (this.exception == null) {
            Handy.writePackedLong(out, 0L);
        } else {
            Handy.writePackedLong(out, 1L);
            this.exception.writeExpr(out, res);
        }
        this.catchAll.write(out, res);
        res.exit();
    }

    @Override
    public String toString() {
        return super.toString() + " finally {\n" + Handy.indentLines(this.catchAll.toString(), "  ") + "\n}";
    }
}

