/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.ListExprAST;
import org.xvm.asm.constants.TypeConstant;

public class TupleExprAST
extends ListExprAST {
    TupleExprAST() {
    }

    public TupleExprAST(TypeConstant type, ExprAST[] values) {
        super(type, values);
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.TupleExpr;
    }

    @Override
    public boolean isAssignable() {
        ExprAST[] values = this.getValues();
        int count = values.length;
        if (count == 0) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (values[i].isAssignable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        for (ExprAST value : this.getValues()) {
            buf.append(value.toString()).append(", ");
        }
        buf.delete(buf.length() - 2, buf.length()).append(')');
        return buf.toString();
    }
}

