/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.DelegatingExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public abstract class UnaryExprAST
extends DelegatingExprAST {
    private TypeConstant type;

    UnaryExprAST() {
    }

    public UnaryExprAST(ExprAST expr, TypeConstant type) {
        super(expr);
        assert (type != null);
        this.type = type;
    }

    @Override
    public TypeConstant getType(int i) {
        assert (i == 0);
        return this.type;
    }

    @Override
    public abstract BinaryAST.NodeType nodeType();

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        super.readBody(in, res);
        this.type = (TypeConstant)res.getConstant(Handy.readMagnitude(in));
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        super.prepareWrite(res);
        this.type = (TypeConstant)res.register(this.type);
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        super.writeBody(out, res);
        Handy.writePackedLong(out, res.indexOf(this.type));
    }
}

