/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.UnaryExprAST;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;

public class UnaryOpExprAST
extends UnaryExprAST {
    private Operator op;

    UnaryOpExprAST() {
    }

    UnaryOpExprAST(BinaryAST.NodeType nodeType) {
        this.op = switch (nodeType) {
            case BinaryAST.NodeType.NotExpr -> Operator.Not;
            case BinaryAST.NodeType.NegExpr -> Operator.Minus;
            case BinaryAST.NodeType.BitNotExpr -> Operator.Compl;
            case BinaryAST.NodeType.PreIncExpr -> Operator.PreInc;
            case BinaryAST.NodeType.PreDecExpr -> Operator.PreDec;
            case BinaryAST.NodeType.PostIncExpr -> Operator.PostInc;
            case BinaryAST.NodeType.PostDecExpr -> Operator.PostDec;
            case BinaryAST.NodeType.RefOfExpr -> Operator.Ref;
            case BinaryAST.NodeType.VarOfExpr -> Operator.Var;
            default -> throw new IllegalArgumentException("nodeType=" + String.valueOf((Object)nodeType));
        };
    }

    public UnaryOpExprAST(ExprAST expr, Operator op, TypeConstant type) {
        super(expr, type);
        this.op = op;
    }

    public Operator getOp() {
        return this.op;
    }

    @Override
    public int getCount() {
        return this.op == Operator.Trace ? this.getExpr().getCount() : super.getCount();
    }

    @Override
    public TypeConstant getType(int i) {
        return this.op == Operator.Trace ? this.getExpr().getType(i) : super.getType(i);
    }

    @Override
    public boolean isConditional() {
        return this.op == Operator.Trace ? this.getExpr().isConditional() : super.isConditional();
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return this.op == null ? BinaryAST.NodeType.UnaryOpExpr : this.op.nodeType;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        super.readBody(in, res);
        if (this.op == null) {
            this.op = Operator.values()[Handy.readMagnitude(in)];
        }
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        super.writeBody(out, res);
        if (this.op.nodeType == BinaryAST.NodeType.UnaryOpExpr) {
            Handy.writePackedLong(out, this.op.ordinal());
        }
    }

    @Override
    public String toString() {
        Object expr = this.getExpr().toString();
        if (((String)expr).contains(" ")) {
            expr = "(" + (String)expr + ")";
        }
        return this.op.pre ? this.op.text + (String)expr : (String)expr + this.op.text;
    }

    public static enum Operator {
        Not("!", true, BinaryAST.NodeType.NotExpr),
        Minus("-", true, BinaryAST.NodeType.NegExpr),
        Compl("~", true, BinaryAST.NodeType.BitNotExpr),
        PreInc("++", true, BinaryAST.NodeType.PreIncExpr),
        PreDec("--", true, BinaryAST.NodeType.PreDecExpr),
        PostInc("++", false, BinaryAST.NodeType.PostIncExpr),
        PostDec("--", false, BinaryAST.NodeType.PostDecExpr),
        Ref("&", true, BinaryAST.NodeType.RefOfExpr),
        Var("&", true, BinaryAST.NodeType.VarOfExpr),
        Type("typeOf:", true, BinaryAST.NodeType.UnaryOpExpr),
        Private("private:", true, BinaryAST.NodeType.UnaryOpExpr),
        Protected("private:", true, BinaryAST.NodeType.UnaryOpExpr),
        Public("public:", true, BinaryAST.NodeType.UnaryOpExpr),
        Pack("", true, BinaryAST.NodeType.UnaryOpExpr),
        ToInt(".TOINT()", false, BinaryAST.NodeType.UnaryOpExpr),
        Trace(".TRACE()", false, BinaryAST.NodeType.UnaryOpExpr);

        public final String text;
        public final boolean pre;
        public final BinaryAST.NodeType nodeType;

        private Operator(String text, boolean pre, BinaryAST.NodeType nodeType) {
            this.text = text;
            this.pre = pre;
            this.nodeType = nodeType;
        }
    }
}

