/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.util.Arrays;
import java.util.Objects;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.DelegatingExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.constants.TypeConstant;

public class UnpackExprAST
extends DelegatingExprAST {
    private TypeConstant[] types;

    UnpackExprAST() {
    }

    public UnpackExprAST(ExprAST expr, TypeConstant[] types) {
        super(expr);
        assert (types != null && Arrays.stream(types).allMatch(Objects::nonNull));
        this.types = types;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.UnpackExpr;
    }

    @Override
    public int getCount() {
        return this.types.length;
    }

    @Override
    public TypeConstant getType(int i) {
        return this.types[i];
    }

    @Override
    public String toString() {
        return "/*unpack*/ " + String.valueOf(this.getExpr());
    }
}

