/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.ast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.RegAllocAST;
import org.xvm.util.Handy;

public class WhileStmtAST
extends BinaryAST {
    private ExprAST cond;
    private BinaryAST body;
    private ExprAST[] specialRegs;
    private ExprAST[] declaredRegs;

    WhileStmtAST() {
    }

    public WhileStmtAST(RegAllocAST[] specialRegs, RegAllocAST[] declaredRegs, ExprAST cond, BinaryAST body) {
        this.specialRegs = specialRegs == null ? NO_ALLOCS : specialRegs;
        this.declaredRegs = declaredRegs == null ? NO_ALLOCS : declaredRegs;
        this.cond = cond;
        this.body = body;
    }

    @Override
    public BinaryAST.NodeType nodeType() {
        return BinaryAST.NodeType.WhileDoStmt;
    }

    public ExprAST getCond() {
        return this.cond;
    }

    public BinaryAST getBody() {
        return this.body;
    }

    @Override
    protected void readBody(DataInput in, BinaryAST.ConstantResolver res) throws IOException {
        res.enter();
        this.specialRegs = WhileStmtAST.readExprArray(in, res);
        this.declaredRegs = WhileStmtAST.readExprArray(in, res);
        this.cond = WhileStmtAST.readExprAST(in, res);
        res.enter();
        this.body = WhileStmtAST.readAST(in, res);
        res.exit();
        res.exit();
    }

    @Override
    public void prepareWrite(BinaryAST.ConstantResolver res) {
        res.enter();
        WhileStmtAST.prepareASTArray(this.specialRegs, res);
        WhileStmtAST.prepareASTArray(this.declaredRegs, res);
        WhileStmtAST.prepareAST(this.cond, res);
        res.enter();
        WhileStmtAST.prepareAST(this.body, res);
        res.exit();
        res.exit();
    }

    @Override
    protected void writeBody(DataOutput out, BinaryAST.ConstantResolver res) throws IOException {
        WhileStmtAST.writeExprArray(this.specialRegs, out, res);
        WhileStmtAST.writeExprArray(this.declaredRegs, out, res);
        WhileStmtAST.writeExprAST(this.cond, out, res);
        WhileStmtAST.writeAST(this.body, out, res);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("while (").append(this.cond).append(") ");
        if (this.body == null) {
            buf.append("{}");
        } else {
            buf.append("{\n");
            buf.append(Handy.indentLines(this.body.toString(), "  "));
            buf.append("\n}");
        }
        return buf.toString();
    }
}

