/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.constants.AbstractDependantTypeConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.ListMap;

public abstract class AbstractDependantChildTypeConstant
extends AbstractDependantTypeConstant {
    public AbstractDependantChildTypeConstant(ConstantPool pool, TypeConstant typeParent) {
        super(pool, typeParent);
    }

    public AbstractDependantChildTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    protected abstract ClassStructure getChildStructure();

    @Override
    public boolean isComposedOfAny(Set<IdentityConstant> setIds) {
        return setIds.contains(this.getChildStructure().getIdentityConstant());
    }

    @Override
    public boolean isImmutable() {
        return this.getChildStructure().isImmutable();
    }

    @Override
    public int getMaxParamsCount() {
        return this.getChildStructure().getTypeParams().size();
    }

    @Override
    public TypeConstant adoptParameters(ConstantPool pool, TypeConstant[] atypeParams) {
        ClassStructure clz;
        TypeConstant typeBase = this;
        if (atypeParams == null) {
            TypeConstant typeParent = this.getParentType();
            TypeConstant typeParentN = typeParent.normalizeParameters();
            if (typeParentN != typeParent) {
                typeBase = this.cloneSingle(pool, typeParentN);
            }
            atypeParams = ConstantPool.NO_TYPES;
        }
        if ((clz = this.getChildStructure()).isParameterized()) {
            return pool.ensureParameterizedTypeConstant(typeBase, clz.normalizeParameters(pool, atypeParams));
        }
        return typeBase;
    }

    @Override
    public TypeConstant[] collectGenericParameters() {
        return this.getChildStructure().getFormalType().getParamTypesArray();
    }

    @Override
    public boolean extendsClass(IdentityConstant constClass) {
        return this.getChildStructure().extendsClass(constClass);
    }

    @Override
    public TypeConstant.Category getCategory() {
        ClassStructure clz = this.getChildStructure();
        return clz.getFormat() == Component.Format.INTERFACE ? TypeConstant.Category.IFACE : TypeConstant.Category.CLASS;
    }

    @Override
    public boolean isSingleUnderlyingClass(boolean fAllowInterface) {
        return fAllowInterface || this.getExplicitClassFormat() != Component.Format.INTERFACE;
    }

    @Override
    public IdentityConstant getSingleUnderlyingClass(boolean fAllowInterface) {
        assert (this.isSingleUnderlyingClass(fAllowInterface));
        return this.getChildStructure().getIdentityConstant();
    }

    @Override
    public boolean isExplicitClassIdentity(boolean fAllowParams) {
        return true;
    }

    @Override
    public Component.Format getExplicitClassFormat() {
        return this.getChildStructure().getFormat();
    }

    @Override
    public TypeConstant getExplicitClassInto(boolean fResolve) {
        ClassStructure struct = this.getChildStructure();
        if (struct == null || struct.getFormat() != Component.Format.ANNOTATION && struct.getFormat() != Component.Format.MIXIN) {
            throw new IllegalStateException("Invalid format for " + String.valueOf(struct));
        }
        return struct.getTypeInto();
    }

    @Override
    public boolean containsGenericParam(String sName) {
        return this.getChildStructure().containsGenericParamType(sName) || this.m_typeParent.containsGenericParam(sName);
    }

    @Override
    protected TypeConstant getGenericParamType(String sName, List<TypeConstant> listParams) {
        TypeConstant type;
        ConstantPool pool = this.getConstantPool();
        TypeConstant typeParent = this.m_typeParent;
        if (typeParent.containsGenericParam(sName)) {
            type = typeParent.getGenericParamType(sName, Collections.emptyList());
        } else {
            AbstractDependantChildTypeConstant typeActual = listParams.isEmpty() ? this : pool.ensureParameterizedTypeConstant(this, listParams.toArray(TypeConstant.NO_TYPES));
            type = this.getChildStructure().getGenericParamType(pool, sName, typeActual);
            if (type != null) {
                type = type.resolveGenerics(pool, typeParent);
            }
        }
        return type;
    }

    @Override
    public boolean isConst() {
        return this.getChildStructure().isConst();
    }

    @Override
    public ComponentResolver.ResolutionResult resolveContributedName(String sName, Constants.Access access, MethodConstant idMethod, ComponentResolver.ResolutionCollector collector) {
        if (this.containsUnresolved()) {
            return ComponentResolver.ResolutionResult.POSSIBLE;
        }
        return this.getChildStructure().resolveName(sName, access, collector);
    }

    @Override
    protected Set<SignatureConstant> isInterfaceAssignableFrom(TypeConstant typeRight, Constants.Access accessLeft, List<TypeConstant> listLeft) {
        ClassStructure clz = this.getChildStructure();
        assert (clz.getFormat() == Component.Format.INTERFACE);
        return clz.isInterfaceAssignableFrom(typeRight, accessLeft, listLeft);
    }

    @Override
    public boolean containsSubstitutableMethod(SignatureConstant signature, Constants.Access access, boolean fFunction, List<TypeConstant> listParams) {
        return this.getChildStructure().containsSubstitutableMethod(this.getConstantPool(), signature, access, fFunction, listParams);
    }

    @Override
    public TypeConstant.Usage checkConsumption(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        if (!listParams.isEmpty()) {
            ConstantPool pool = this.getConstantPool();
            ClassStructure clz = this.getChildStructure();
            ListMap<StringConstant, TypeConstant> mapFormal = clz.getTypeParams();
            listParams = clz.normalizeParameters(pool, listParams);
            Iterator<TypeConstant> iterParams = listParams.iterator();
            Iterator iterNames = mapFormal.keySet().iterator();
            while (iterParams.hasNext()) {
                TypeConstant constParam = iterParams.next();
                String sFormal = ((StringConstant)iterNames.next()).getValue();
                if ((!constParam.consumesFormalType(sTypeName, access) || !clz.producesFormalType(pool, sFormal, access, listParams)) && (!constParam.producesFormalType(sTypeName, access) || !clz.consumesFormalType(pool, sFormal, access, listParams))) continue;
                return TypeConstant.Usage.YES;
            }
        }
        return TypeConstant.Usage.NO;
    }

    @Override
    public TypeConstant.Usage checkProduction(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        if (!listParams.isEmpty()) {
            ConstantPool pool = this.getConstantPool();
            ClassStructure clz = this.getChildStructure();
            ListMap<StringConstant, TypeConstant> mapFormal = clz.getTypeParams();
            listParams = clz.normalizeParameters(pool, listParams);
            Iterator<TypeConstant> iterParams = listParams.iterator();
            Iterator iterNames = mapFormal.keySet().iterator();
            while (iterParams.hasNext()) {
                TypeConstant constParam = iterParams.next();
                String sFormal = ((StringConstant)iterNames.next()).getValue();
                if ((!constParam.producesFormalType(sTypeName, access) || !clz.producesFormalType(pool, sFormal, access, listParams)) && (!constParam.consumesFormalType(sTypeName, access) || !clz.consumesFormalType(pool, sFormal, access, listParams))) continue;
                return TypeConstant.Usage.YES;
            }
        }
        return TypeConstant.Usage.NO;
    }
}

