/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.Register;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.util.Handy;

public abstract class AbstractDependantTypeConstant
extends TypeConstant {
    protected TypeConstant m_typeParent;
    private transient int m_iTypeParent;

    public AbstractDependantTypeConstant(ConstantPool pool, TypeConstant typeParent) {
        super(pool);
        if (typeParent == null) {
            throw new IllegalArgumentException("parent type is required");
        }
        this.m_typeParent = typeParent.resolveTypedefs();
    }

    public AbstractDependantTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iTypeParent = Handy.readIndex(in);
    }

    @Override
    protected void resolveConstants() {
        this.m_typeParent = (TypeConstant)this.getConstantPool().getConstant(this.m_iTypeParent);
    }

    @Override
    public boolean isShared(ConstantPool poolOther) {
        return this.m_typeParent.isShared(poolOther);
    }

    @Override
    public boolean isComposedOfAny(Set<IdentityConstant> setIds) {
        return setIds.contains(this.getSingleUnderlyingClass(true));
    }

    @Override
    public boolean isImmutabilitySpecified() {
        return false;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isAccessSpecified() {
        return false;
    }

    @Override
    public Constants.Access getAccess() {
        return Constants.Access.PUBLIC;
    }

    @Override
    public boolean isAccessModifiable() {
        return false;
    }

    @Override
    public boolean isParamsSpecified() {
        return false;
    }

    @Override
    public int getTypeDepth() {
        return 1 + this.m_typeParent.getTypeDepth();
    }

    @Override
    public boolean isAnnotated() {
        return false;
    }

    @Override
    public TypeConstant getParentType() {
        return this.m_typeParent;
    }

    @Override
    public boolean isSingleDefiningConstant() {
        return true;
    }

    @Override
    public Constant getDefiningConstant() {
        return this.getSingleUnderlyingClass(true);
    }

    @Override
    public TypeConstant resolveTypedefs() {
        TypeConstant typeOriginal = this.m_typeParent;
        TypeConstant typeResolved = typeOriginal.resolveTypedefs();
        return typeOriginal == typeResolved ? this : this.cloneSingle(this.getConstantPool(), typeResolved);
    }

    @Override
    public TypeConstant resolveGenerics(ConstantPool pool, GenericTypeResolver resolver) {
        TypeConstant typeOriginal = this.m_typeParent;
        TypeConstant typeResolved = typeOriginal.resolveGenerics(pool, resolver);
        return typeOriginal == typeResolved ? this : this.cloneSingle(pool, typeResolved);
    }

    @Override
    public TypeConstant resolveConstraints(boolean fPendingOnly) {
        TypeConstant constOriginal = this.getParentType();
        TypeConstant constResolved = constOriginal.resolveConstraints(fPendingOnly);
        return constResolved == constOriginal ? this : this.cloneSingle(this.getConstantPool(), constResolved);
    }

    @Override
    public TypeConstant resolveDynamicConstraints(Register register) {
        TypeConstant constOriginal = this.getParentType();
        TypeConstant constResolved = constOriginal.resolveDynamicConstraints(register);
        return constResolved == constOriginal ? this : this.cloneSingle(this.getConstantPool(), constResolved);
    }

    @Override
    public boolean containsAutoNarrowing(boolean fAllowVirtChild) {
        return false;
    }

    @Override
    public boolean isAutoNarrowing() {
        return false;
    }

    @Override
    public TypeConstant ensureAutoNarrowing() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypeConstant resolveAutoNarrowing(ConstantPool pool, boolean fRetainParams, TypeConstant typeTarget, IdentityConstant idCtx) {
        return this;
    }

    @Override
    public TypeConstant resolveTypeParameter(TypeConstant typeActual, String sFormalName) {
        return typeActual.isVirtualChild() || typeActual.isAnonymousClass() ? this.getParentType().resolveTypeParameter(typeActual.getParentType(), sFormalName) : null;
    }

    @Override
    public boolean containsFormalType(boolean fAllowParams) {
        return this.getParentType().containsFormalType(fAllowParams);
    }

    @Override
    public void collectFormalTypes(boolean fAllowParams, Set<TypeConstant> setFormal) {
        this.getParentType().collectFormalTypes(fAllowParams, setFormal);
    }

    @Override
    public boolean containsDynamicType(Register register) {
        return this.getParentType().containsDynamicType(register);
    }

    @Override
    public boolean containsGenericType(boolean fAllowParams) {
        return this.getParentType().containsGenericType(fAllowParams);
    }

    @Override
    public boolean containsTypeParameter(boolean fAllowParams) {
        return this.getParentType().containsTypeParameter(fAllowParams);
    }

    @Override
    public boolean containsRecursiveType() {
        return this.getParentType().containsRecursiveType();
    }

    @Override
    public boolean containsFunctionType() {
        return false;
    }

    @Override
    public boolean isTuple() {
        return false;
    }

    @Override
    public boolean isOnlyNullable() {
        return false;
    }

    @Override
    public boolean isIntoPropertyType() {
        return false;
    }

    @Override
    public TypeConstant getIntoPropertyType() {
        return null;
    }

    @Override
    public boolean isIntoVariableType() {
        return false;
    }

    @Override
    public TypeConstant getIntoVariableType() {
        return null;
    }

    @Override
    public boolean isIntoMetaData(TypeConstant typeTarget, boolean fStrict) {
        return false;
    }

    @Override
    public boolean isTypeOfType() {
        return false;
    }

    @Override
    public ClassTemplate getTemplate(Container container) {
        return container.getTemplate((ClassConstant)this.getDefiningConstant());
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_typeParent.containsUnresolved();
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_typeParent);
    }

    @Override
    protected int compareDetails(Constant obj) {
        if (!(obj instanceof AbstractDependantTypeConstant)) {
            return -1;
        }
        AbstractDependantTypeConstant that = (AbstractDependantTypeConstant)obj;
        return this.m_typeParent.compareTo(that.m_typeParent);
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_typeParent = (TypeConstant)pool.register(this.m_typeParent);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_typeParent.getPosition());
    }
}

