/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.ImmutableTypeConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyClassTypeConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.util.Handy;
import org.xvm.util.Hash;
import org.xvm.util.Severity;

public class AccessTypeConstant
extends TypeConstant {
    private transient int m_iType;
    private TypeConstant m_constType;
    private final Constants.Access m_access;

    public AccessTypeConstant(ConstantPool pool, TypeConstant constType, Constants.Access access) {
        super(pool);
        if (constType == null) {
            throw new IllegalArgumentException("type is required");
        }
        if (access == null) {
            throw new IllegalArgumentException("access is required");
        }
        if (constType.isAccessSpecified()) {
            throw new IllegalArgumentException("type access is already specified");
        }
        if (!constType.isSingleDefiningConstant()) {
            throw new IllegalArgumentException("access cannot be specified for a relational type");
        }
        this.m_constType = constType;
        this.m_access = access;
    }

    public AccessTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iType = Handy.readIndex(in);
        this.m_access = Constants.Access.valueOf(Handy.readIndex(in));
    }

    @Override
    protected void resolveConstants() {
        this.m_constType = (TypeConstant)this.getConstantPool().getConstant(this.m_iType);
    }

    @Override
    public boolean isModifyingType() {
        return true;
    }

    @Override
    public TypeConstant getUnderlyingType() {
        return this.m_constType;
    }

    @Override
    public boolean isImmutable() {
        if (this.m_access == Constants.Access.STRUCT) {
            return false;
        }
        return super.isImmutable();
    }

    @Override
    public boolean isAccessSpecified() {
        return true;
    }

    @Override
    public Constants.Access getAccess() {
        return this.m_access;
    }

    @Override
    public boolean isAccessModifiable() {
        return true;
    }

    @Override
    public TypeConstant removeAccess() {
        return this.m_constType;
    }

    @Override
    public TypeConstant ensureAccess(Constants.Access access) {
        return access == this.m_access ? this : this.getConstantPool().ensureAccessTypeConstant(this.m_constType, access);
    }

    @Override
    public boolean isNullable() {
        assert (!this.m_constType.isNullable());
        return false;
    }

    @Override
    protected TypeConstant cloneSingle(ConstantPool pool, TypeConstant type) {
        return pool.ensureAccessTypeConstant(type, this.m_access);
    }

    @Override
    public ComponentResolver.ResolutionResult resolveContributedName(String sName, Constants.Access access, MethodConstant idMethod, ComponentResolver.ResolutionCollector collector) {
        access = this.m_access == Constants.Access.STRUCT || access == Constants.Access.STRUCT ? Constants.Access.PRIVATE : this.m_access.minOf(access);
        return super.resolveContributedName(sName, access, idMethod, collector);
    }

    @Override
    protected TypeInfo buildTypeInfo(ErrorListener errs) {
        TypeInfo typeInfo;
        Constants.Access access = this.m_access;
        if (access == Constants.Access.PUBLIC || access == Constants.Access.PROTECTED) {
            TypeInfo info = this.getConstantPool().ensureAccessTypeConstant(this.getUnderlyingType(), Constants.Access.PRIVATE).ensureTypeInfoInternal(errs);
            return info == null ? null : info.limitAccess(access);
        }
        TypeConstant typeConstant = this.m_constType;
        if (typeConstant instanceof ImmutableTypeConstant) {
            ImmutableTypeConstant typeUnder = (ImmutableTypeConstant)typeConstant;
            typeInfo = typeUnder.getUnderlyingType().ensureAccess(Constants.Access.PRIVATE).ensureTypeInfo(errs);
        } else {
            typeInfo = super.buildTypeInfo(errs);
        }
        return typeInfo;
    }

    @Override
    public void invalidateTypeInfo() {
        super.invalidateTypeInfo();
        this.getUnderlyingType().clearTypeInfo();
        if (this.getAccess() != Constants.Access.PRIVATE) {
            this.getConstantPool().ensureAccessTypeConstant(this.getUnderlyingType(), Constants.Access.PRIVATE).clearTypeInfo();
        }
    }

    @Override
    protected Set<SignatureConstant> isInterfaceAssignableFrom(TypeConstant typeRight, Constants.Access accessLeft, List<TypeConstant> listLeft) {
        return super.isInterfaceAssignableFrom(typeRight, this.m_access, listLeft);
    }

    @Override
    public TypeConstant.Usage checkConsumption(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return super.checkConsumption(sTypeName, this.m_access, listParams);
    }

    @Override
    public TypeConstant.Usage checkProduction(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return super.checkProduction(sTypeName, this.m_access, listParams);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.AccessType;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_constType.containsUnresolved();
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constType);
    }

    @Override
    protected Object getLocator() {
        return this.m_access == Constants.Access.PUBLIC ? this.m_constType : null;
    }

    @Override
    protected int compareDetails(Constant obj) {
        if (!(obj instanceof AccessTypeConstant)) {
            return -1;
        }
        AccessTypeConstant that = (AccessTypeConstant)obj;
        int n = this.m_constType.compareTo(that.m_constType);
        if (n == 0) {
            n = this.m_access.compareTo(that.m_access);
        }
        return n;
    }

    @Override
    public String getValueString() {
        return this.m_constType.getValueString() + ":" + this.m_access.KEYWORD;
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constType = (TypeConstant)pool.register(this.m_constType);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constType.getPosition());
        Handy.writePackedLong(out, this.m_access.ordinal());
    }

    @Override
    public boolean validate(ErrorListener errs) {
        if (!this.isValidated()) {
            TypeConstant type = this.m_constType.resolveTypedefs();
            if (!(type instanceof PropertyClassTypeConstant) && !type.isExplicitClassIdentity(true)) {
                this.log(errs, Severity.ERROR, "VERIFY-29", type.getValueString());
                return true;
            }
            return super.validate(errs);
        }
        return false;
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constType, Hash.of((Object)this.m_access));
    }
}

