/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.Version;
import org.xvm.asm.constants.AnyCondition;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.MultiCondition;
import org.xvm.asm.constants.NotCondition;
import org.xvm.asm.constants.VersionedCondition;

public class AllCondition
extends MultiCondition {
    public AllCondition(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    public AllCondition(ConstantPool pool, ConditionalConstant ... aconstCond) {
        super(pool, AllCondition.mergeAnds(aconstCond));
    }

    private AllCondition(ConditionalConstant[] acond) {
        super(acond[0].getConstantPool(), acond);
    }

    @Override
    public boolean evaluate(LinkerContext ctx) {
        for (ConditionalConstant constCond : this.m_aconstCond) {
            if (constCond.evaluate(ctx)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean testEvaluate(long n) {
        for (ConditionalConstant constCond : this.m_aconstCond) {
            if (constCond.testEvaluate(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Version> versions() {
        Set<Version> setVers = null;
        for (ConditionalConstant cond : this.m_aconstCond) {
            Set<Version> setNew = cond.versions();
            if (setNew.isEmpty()) continue;
            if (setVers == null) {
                setVers = setNew;
                continue;
            }
            throw new IllegalStateException("can't have two version conditions in an AllCondition: " + String.valueOf(setVers) + ", " + String.valueOf(setNew));
        }
        return setVers == null ? Collections.emptySet() : setVers;
    }

    @Override
    public ConditionalConstant addVersion(Version ver) {
        if (this.versions().contains(ver)) {
            return this;
        }
        ConditionalConstant[] acondOld = this.m_aconstCond;
        int cConds = acondOld.length;
        ConditionalConstant condLast = acondOld[cConds - 1];
        if (condLast instanceof AnyCondition) {
            AnyCondition condAny = (AnyCondition)condLast;
            if (condAny.isOnlyVersions()) {
                ConditionalConstant[] acondNew = (ConditionalConstant[])acondOld.clone();
                acondNew[cConds - 1] = condAny.addVersion(ver);
                return new AllCondition(acondNew);
            }
        } else if (condLast instanceof VersionedCondition) {
            ConstantPool pool = this.getConstantPool();
            ConditionalConstant[] acondNew = (ConditionalConstant[])acondOld.clone();
            acondNew[cConds - 1] = new AnyCondition(pool, condLast, pool.ensureVersionedCondition(ver));
            return new AllCondition(acondNew);
        }
        assert (this.versions().isEmpty());
        ConditionalConstant[] acondNew = new ConditionalConstant[cConds + 1];
        System.arraycopy(acondOld, 0, acondNew, 0, cConds);
        acondNew[cConds] = this.getConstantPool().ensureVersionedCondition(ver);
        return new AllCondition(acondNew);
    }

    @Override
    public ConditionalConstant removeVersion(Version ver) {
        if (!this.versions().contains(ver)) {
            return this;
        }
        ConditionalConstant[] acondOld = this.m_aconstCond;
        int cConds = acondOld.length;
        ConditionalConstant condLast = acondOld[cConds - 1];
        if (condLast instanceof AnyCondition) {
            assert (condLast.versions().contains(ver));
            ConditionalConstant[] acondNew = (ConditionalConstant[])acondOld.clone();
            acondNew[cConds - 1] = condLast.removeVersion(ver);
            return new AllCondition(acondNew);
        }
        if (condLast instanceof VersionedCondition) {
            assert (ver.equals(((VersionedCondition)condLast).getVersion()));
            switch (cConds) {
                case 0: 
                case 1: {
                    throw new IllegalStateException("unexpectedly small AllCondition: " + cConds);
                }
                case 2: {
                    return acondOld[0];
                }
            }
            ConditionalConstant[] acondNew = new ConditionalConstant[cConds - 1];
            System.arraycopy(acondOld, 0, acondNew, 0, cConds - 1);
            return new AllCondition(acondNew);
        }
        throw new IllegalStateException("version not found at end of conditions");
    }

    @Override
    public boolean isTerminalInfluenceBruteForce() {
        return !this.isTerminalInfluenceFinessable(false, new HashSet<ConditionalConstant>(), new HashSet<ConditionalConstant>());
    }

    @Override
    protected boolean isTerminalInfluenceFinessable(boolean fInNot, Set<ConditionalConstant> setSimple, Set<ConditionalConstant> setComplex) {
        Set<ConditionalConstant> terminals = this.terminals();
        int cTerminals = terminals.size();
        ConditionalConstant[] aTerminals = terminals.toArray(new ConditionalConstant[cTerminals]);
        for (int iThis = 0; iThis < cTerminals; ++iThis) {
            ConditionalConstant condThis = aTerminals[iThis];
            if (condThis instanceof VersionedCondition) continue;
            for (int iThat = iThis + 1; iThat < cTerminals; ++iThat) {
                ConditionalConstant condThat = aTerminals[iThat];
                if (condThat instanceof VersionedCondition || condThis.calcRelation(condThat) == ConditionalConstant.Relation.INDEP) continue;
                return false;
            }
        }
        Iterator<ConditionalConstant> iter = this.flatIterator();
        while (iter.hasNext()) {
            if (iter.next().isTerminalInfluenceFinessable(fInNot, setSimple, setComplex)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<ConditionalConstant, ConditionalConstant.Influence> terminalInfluences() {
        HashMap<ConditionalConstant, ConditionalConstant.Influence> influences;
        block16: {
            if (this.isTerminalInfluenceBruteForce()) {
                return super.terminalInfluences();
            }
            influences = new HashMap<ConditionalConstant, ConditionalConstant.Influence>();
            HashSet<VersionedCondition> setVerConds = new HashSet<VersionedCondition>();
            HashSet<Version> setVers = null;
            Iterator<ConditionalConstant> iter = this.flatIterator();
            while (iter.hasNext()) {
                ConditionalConstant conditionalConstant = iter.next();
                if (conditionalConstant instanceof VersionedCondition || conditionalConstant instanceof AnyCondition) {
                    if (setVers == null) {
                        setVers = new HashSet<Version>(conditionalConstant.versions());
                    } else {
                        setVers.retainAll(conditionalConstant.versions());
                    }
                    if (conditionalConstant instanceof VersionedCondition) {
                        setVerConds.add((VersionedCondition)conditionalConstant);
                        continue;
                    }
                    Iterator<Object> iterVerCond = ((AnyCondition)conditionalConstant).flatIterator();
                    while (iterVerCond.hasNext()) {
                        setVerConds.add((VersionedCondition)iterVerCond.next());
                    }
                    continue;
                }
                if (conditionalConstant.isTerminal()) {
                    influences.put(conditionalConstant, ConditionalConstant.Influence.AND);
                    continue;
                }
                assert (conditionalConstant instanceof NotCondition);
                for (Map.Entry entry : conditionalConstant.terminalInfluences().entrySet()) {
                    influences.put((ConditionalConstant)entry.getKey(), ((ConditionalConstant.Influence)((Object)entry.getValue())).and());
                }
            }
            if (setVers == null) break block16;
            if (setVers.isEmpty()) {
                for (Map.Entry entry : influences.entrySet()) {
                    entry.setValue(ConditionalConstant.Influence.ALWAYS_F);
                }
                for (VersionedCondition versionedCondition : setVerConds) {
                    influences.put(versionedCondition, ConditionalConstant.Influence.ALWAYS_F);
                }
            } else {
                for (VersionedCondition versionedCondition : setVerConds) {
                    void var7_17;
                    Version ver = versionedCondition.getVersion();
                    ConditionalConstant.Influence influence = ConditionalConstant.Influence.ALWAYS_F;
                    if (setVers.contains(ver)) {
                        ConditionalConstant.Influence influence2 = setVers.size() == 1 ? ConditionalConstant.Influence.AND : ConditionalConstant.Influence.CONTRIB;
                    }
                    influences.put(versionedCondition, (ConditionalConstant.Influence)var7_17);
                }
            }
        }
        return influences;
    }

    @Override
    protected String getOperatorString() {
        return "&&";
    }

    @Override
    protected AllCondition instantiate(ConditionalConstant[] aconstCond) {
        return new AllCondition(this.getConstantPool(), aconstCond);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.ConditionAll;
    }

    protected static ConditionalConstant[] mergeAnds(ConditionalConstant[] aconstCond) {
        assert (aconstCond != null);
        assert (aconstCond.length > 1);
        boolean fAnds = false;
        int cConds = 0;
        for (ConditionalConstant cond : aconstCond) {
            if (cond instanceof AllCondition) {
                fAnds = true;
                cConds += AllCondition.mergeAnds(((AllCondition)cond).m_aconstCond).length;
                continue;
            }
            ++cConds;
        }
        if (!fAnds) {
            return aconstCond;
        }
        ConditionalConstant[] aconstMerged = new ConditionalConstant[cConds];
        int ofNew = 0;
        for (ConditionalConstant cond : aconstCond) {
            if (cond instanceof AllCondition) {
                ConditionalConstant[] aconstCopy = AllCondition.mergeAnds(((AllCondition)cond).m_aconstCond);
                int cCopy = aconstCopy.length;
                System.arraycopy(aconstCopy, 0, aconstMerged, ofNew, cCopy);
                ofNew += cCopy;
                continue;
            }
            aconstMerged[ofNew++] = cond;
        }
        assert (ofNew == cConds);
        return aconstMerged;
    }
}

