/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.DifferenceTypeConstant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.RegisterConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.UnionTypeConstant;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Container;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.util.Handy;
import org.xvm.util.Hash;
import org.xvm.util.Severity;

public class AnnotatedTypeConstant
extends TypeConstant {
    private int m_iAnno;
    private int m_iType;
    private Annotation m_annotation;
    private TypeConstant m_constType;
    private transient TypeConstant m_typeAnno;

    public AnnotatedTypeConstant(ConstantPool pool, Constant constClass, Constant[] aconstParam, TypeConstant constType) {
        super(pool);
        if (constClass == null) {
            throw new IllegalArgumentException("annotation class required");
        }
        if (aconstParam != null) {
            Handy.checkElementsNonNull(aconstParam);
        }
        if (constType == null) {
            throw new IllegalArgumentException("annotated type required");
        }
        this.m_annotation = pool.ensureAnnotation(constClass, aconstParam);
        this.m_constType = constType;
    }

    public AnnotatedTypeConstant(ConstantPool pool, Annotation annotation, TypeConstant constType) {
        super(pool);
        if (annotation == null) {
            throw new IllegalArgumentException("annotation required");
        }
        if (constType == null) {
            throw new IllegalArgumentException("annotated type required");
        }
        this.m_annotation = annotation;
        this.m_constType = constType;
    }

    public AnnotatedTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iAnno = Handy.readIndex(in);
        this.m_iType = Handy.readIndex(in);
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_annotation = (Annotation)pool.getConstant(this.m_iAnno);
        this.m_constType = (TypeConstant)pool.getConstant(this.m_iType);
    }

    public Annotation getAnnotation() {
        return this.m_annotation;
    }

    public TypeConstant getAnnotationType() {
        TypeConstant typeAnno = this.m_typeAnno;
        if (typeAnno != null) {
            return typeAnno;
        }
        ClassStructure anno = (ClassStructure)this.getAnnotationClass().getComponent();
        if (!anno.isParameterizedDeep()) {
            return anno.getCanonicalType();
        }
        TypeConstant typeFormal = anno.getFormalType();
        TypeConstant typeInto = anno.getTypeInto();
        TypeConstant typeActual = this.m_constType;
        HashMap<String, TypeConstant> mapResolve = new HashMap<String, TypeConstant>();
        for (Map.Entry<StringConstant, TypeConstant> entry : anno.getTypeParamsAsList()) {
            String sName = entry.getKey().getValue();
            TypeConstant type = typeInto.resolveTypeParameter(typeActual, sName);
            if (type == null) continue;
            mapResolve.put(sName, type);
        }
        this.m_typeAnno = typeFormal.resolveGenerics(this.getConstantPool(), mapResolve::get);
        return this.m_typeAnno;
    }

    public ClassConstant getAnnotationClass() {
        return (ClassConstant)this.m_annotation.getAnnotationClass();
    }

    public Constant[] getAnnotationParams() {
        return this.m_annotation.getParams();
    }

    public AnnotatedTypeConstant stripParameters() {
        TypeConstant typeUnderlying = this.getUnderlyingType();
        boolean fDiff = false;
        if (typeUnderlying instanceof AnnotatedTypeConstant) {
            AnnotatedTypeConstant typeAnno = (AnnotatedTypeConstant)typeUnderlying;
            AnnotatedTypeConstant typeU = typeAnno.stripParameters();
            fDiff = typeU != typeUnderlying;
            typeUnderlying = typeU;
        }
        return fDiff || this.getAnnotationParams().length > 0 ? this.getConstantPool().ensureAnnotatedTypeConstant(this.getAnnotationClass(), Constant.NO_CONSTS, typeUnderlying) : this;
    }

    public boolean containsRegisterParameters() {
        AnnotatedTypeConstant typeAnno;
        for (Constant constParam : this.getAnnotationParams()) {
            if (!(constParam instanceof RegisterConstant)) continue;
            return true;
        }
        TypeConstant typeUnderlying = this.getUnderlyingType();
        return typeUnderlying instanceof AnnotatedTypeConstant && (typeAnno = (AnnotatedTypeConstant)typeUnderlying).containsRegisterParameters();
    }

    @Override
    public boolean isModifyingType() {
        return true;
    }

    @Override
    public TypeConstant getUnderlyingType() {
        return this.m_constType;
    }

    @Override
    public boolean isShared(ConstantPool poolOther) {
        return super.isShared(poolOther) && this.getAnnotationClass().isShared(poolOther);
    }

    @Override
    public boolean isAccessModifiable() {
        return false;
    }

    @Override
    public boolean isAnnotated() {
        return true;
    }

    @Override
    public boolean containsAnnotation(ClassConstant idAnno) {
        return this.getAnnotationClass().equals(idAnno) || super.containsAnnotation(idAnno);
    }

    @Override
    public Annotation[] getAnnotations() {
        ArrayList<Annotation> listAnnos = new ArrayList<Annotation>();
        AnnotatedTypeConstant typeAnno = this;
        while (true) {
            AnnotatedTypeConstant typeNextA;
            listAnnos.add(typeAnno.getAnnotation());
            TypeConstant typeNext = typeAnno.getUnderlyingType();
            if (!(typeNext instanceof AnnotatedTypeConstant)) break;
            typeAnno = typeNextA = (AnnotatedTypeConstant)typeNext;
        }
        return listAnnos.toArray(Annotation.NO_ANNOTATIONS);
    }

    @Override
    public boolean isNullable() {
        return this.m_constType.isNullable();
    }

    @Override
    public TypeConstant removeNullable() {
        return this.isNullable() ? this.getConstantPool().ensureAnnotatedTypeConstant(this.getAnnotationClass(), this.getAnnotationParams(), this.m_constType.removeNullable()) : this;
    }

    @Override
    public TypeConstant andNot(ConstantPool pool, TypeConstant that) {
        TypeConstant typeBaseR;
        TypeConstant typeAnno = this.getAnnotationType();
        TypeConstant typeBase = this.getUnderlyingType().resolveTypedefs();
        if (typeAnno.equals(that)) {
            return typeBase;
        }
        if (that.isA(typeBase)) {
            return pool.typeObject();
        }
        if (typeBase.isAnnotated() && (typeBaseR = typeBase.andNot(pool, that)) != null && typeBaseR != typeBase && !(typeBaseR instanceof DifferenceTypeConstant)) {
            return this.cloneSingle(pool, typeBaseR);
        }
        return super.andNot(pool, that);
    }

    @Override
    protected TypeConstant cloneSingle(ConstantPool pool, TypeConstant type) {
        return pool.ensureAnnotatedTypeConstant(this.m_annotation.getAnnotationClass(), this.m_annotation.getParams(), type);
    }

    @Override
    public boolean containsGenericParam(String sName) {
        return super.containsGenericParam(sName) || this.getAnnotationType().containsGenericParam(sName);
    }

    @Override
    protected TypeConstant getGenericParamType(String sName, List<TypeConstant> listParams) {
        assert (listParams.isEmpty());
        TypeConstant type = super.getGenericParamType(sName, listParams);
        return type == null ? this.getAnnotationType().resolveGenericType(sName) : type;
    }

    @Override
    public TypeConstant resolveGenerics(ConstantPool pool, GenericTypeResolver resolver) {
        TypeConstant constOriginal = this.getUnderlyingType();
        TypeConstant constResolved = constOriginal.resolveGenerics(pool, resolver);
        return constResolved == constOriginal || constResolved.isRelationalType() ? this : this.cloneSingle(pool, constResolved);
    }

    @Override
    public TypeConstant resolveAutoNarrowing(ConstantPool pool, boolean fRetainParams, TypeConstant typeTarget, IdentityConstant idCtx) {
        TypeConstant constOriginal = this.getUnderlyingType();
        TypeConstant constResolved = constOriginal.resolveAutoNarrowing(pool, fRetainParams, typeTarget, idCtx);
        return constResolved == constOriginal ? this : (constResolved.isAnnotated() && constResolved.containsAnnotation((ClassConstant)this.m_annotation.getAnnotationClass()) ? constResolved : this.cloneSingle(pool, constResolved));
    }

    @Override
    public TypeInfo ensureTypeInfo(ErrorListener errs) {
        if (this.m_annotation.containsUnresolved() && this.m_annotation.getParams().length > 0) {
            AnnotatedTypeConstant typeSansParams = this.getConstantPool().ensureAnnotatedTypeConstant(this.m_annotation.getAnnotationClass(), Constant.NO_CONSTS, this.m_constType);
            return typeSansParams.ensureTypeInfo(errs);
        }
        return super.ensureTypeInfo(errs);
    }

    TypeInfo buildPrivateInfo(ErrorListener errs) {
        ClassStructure struct;
        IdentityConstant idBase;
        assert (this.getAccess() == Constants.Access.PUBLIC);
        ConstantPool pool = this.getConstantPool();
        int cInvals = pool.getInvalidationCount();
        ArrayList<Annotation> listClassAnnos = new ArrayList<Annotation>();
        ArrayList<Annotation> listMixinAnnos = new ArrayList<Annotation>();
        TypeConstant typeBase = this.extractAnnotation(listClassAnnos, listMixinAnnos, errs);
        if (typeBase == null) {
            return null;
        }
        if (typeBase.isFormalType()) {
            typeBase = ((FormalConstant)typeBase.getDefiningConstant()).getConstraintType();
        }
        Annotation[] aAnnoClass = listClassAnnos.toArray(Annotation.NO_ANNOTATIONS);
        TypeConstant typePrivateBase = pool.ensureAccessTypeConstant(typeBase, Constants.Access.PRIVATE);
        TypeInfo infoBase = typePrivateBase.ensureTypeInfoInternal(errs);
        if (!AnnotatedTypeConstant.isComplete(infoBase)) {
            return infoBase;
        }
        try {
            idBase = (IdentityConstant)typeBase.getDefiningConstant();
            struct = (ClassStructure)idBase.getComponent();
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Unable to determine class for " + this.getValueString(), e);
        }
        if (listMixinAnnos.isEmpty()) {
            assert (aAnnoClass.length > 0);
            TypeConstant typeTarget = pool.ensureAccessTypeConstant(this, Constants.Access.PRIVATE);
            return new TypeInfo(typeTarget, cInvals, struct, 0, false, infoBase.getTypeParams(), aAnnoClass, infoBase.getMixinAnnotations(), infoBase.getExtends(), infoBase.getRebases(), infoBase.getInto(), infoBase.getContributionList(), infoBase.getClassChain(), infoBase.getDefaultChain(), infoBase.getProperties(), infoBase.getMethods(), infoBase.getVirtProperties(), infoBase.getVirtMethods(), infoBase.getChildInfosByName(), null, TypeInfo.Progress.Complete);
        }
        TypeConstant typeTarget = pool.ensureAccessTypeConstant(this, Constants.Access.PRIVATE);
        Annotation[] aAnnoMixin = listMixinAnnos.toArray(Annotation.NO_ANNOTATIONS);
        return typeTarget.layerOnAnnotations(idBase, struct, infoBase, aAnnoMixin, aAnnoClass, cInvals, errs);
    }

    public TypeConstant extractAnnotation(List<Annotation> listClassAnnos, List<Annotation> listMixinAnnos, ErrorListener errs) {
        ArrayList<Constant> listAnnoClz = new ArrayList<Constant>();
        TypeConstant typeCurr = this;
        block3: while (true) {
            switch (((TypeConstant)typeCurr).getFormat()) {
                case AnnotatedType: {
                    AnnotatedTypeConstant constAnno = typeCurr;
                    Annotation annotation = constAnno.getAnnotation();
                    TypeConstant typeAnno = constAnno.getAnnotationType();
                    TypeConstant typeNext = ((TypeConstant)typeCurr).getUnderlyingType();
                    if (!typeAnno.isExplicitClassIdentity(true)) {
                        this.log(errs, Severity.ERROR, "VERIFY-07", typeNext.getValueString(), typeAnno.getValueString());
                        return null;
                    }
                    if (typeAnno.getExplicitClassFormat() != Component.Format.ANNOTATION) {
                        this.log(errs, Severity.ERROR, "VERIFY-27", typeAnno.getValueString());
                        return null;
                    }
                    if (typeAnno.containsAutoNarrowing(false)) {
                        this.log(errs, Severity.WARNING, "VERIFY-82", typeAnno.getValueString(), this.getValueString());
                        typeAnno = typeAnno.removeAutoNarrowing();
                    }
                    if (listAnnoClz.contains(annotation.getAnnotationClass())) {
                        this.log(errs, Severity.ERROR, "VERIFY-52", this.getValueString(), annotation.getAnnotationClass().getValueString());
                        return null;
                    }
                    TypeConstant typeInto = typeAnno.getExplicitClassInto(true);
                    if (this.getUnderlyingType().isA(typeInto)) {
                        listMixinAnnos.add(annotation);
                    } else if (typeInto.isIntoClassType()) {
                        listClassAnnos.add(annotation);
                    } else {
                        this.log(errs, Severity.ERROR, "VERIFY-32", ((TypeConstant)typeCurr).getUnderlyingType().getValueString(), typeAnno.getValueString(), typeInto.getValueString());
                        return null;
                    }
                    listAnnoClz.add(constAnno.getAnnotation().getAnnotationClass());
                    typeCurr = typeNext;
                    continue block3;
                }
            }
            break;
        }
        if (((TypeConstant)typeCurr).isAnnotated()) {
            this.log(errs, Severity.ERROR, "VERIFY-26", ((Constant)typeCurr).getValueString());
            return null;
        }
        return typeCurr;
    }

    @Override
    protected TypeConstant.Relation calculateRelationToLeft(TypeConstant typeLeft) {
        if (typeLeft.isRelationalType() || typeLeft.isAnnotated()) {
            return super.calculateRelationToLeft(typeLeft);
        }
        TypeConstant typeAnno = this.getAnnotationType();
        TypeConstant typeOrig = this.getUnderlyingType();
        TypeConstant.Relation rel1 = typeAnno.calculateRelation(typeLeft);
        TypeConstant.Relation rel2 = typeOrig.calculateRelation(typeLeft);
        return rel1.bestOf(rel2);
    }

    @Override
    protected TypeConstant.Relation calculateRelationToRight(TypeConstant typeRight) {
        TypeConstant typeAnno = this.getAnnotationType();
        TypeConstant typeOrig = this.getUnderlyingType();
        TypeConstant.Relation rel1 = typeRight.calculateRelation(typeAnno);
        TypeConstant.Relation rel2 = typeRight.calculateRelation(typeOrig);
        return rel1.worseOf(rel2);
    }

    @Override
    protected TypeConstant.Relation findUnionContribution(UnionTypeConstant typeLeft) {
        return TypeConstant.Relation.INCOMPATIBLE;
    }

    @Override
    public boolean containsSubstitutableMethod(SignatureConstant signature, Constants.Access access, boolean fFunction, List<TypeConstant> listParams) {
        TypeConstant typeAnno = this.getAnnotationType();
        TypeConstant typeOrig = this.getUnderlyingType();
        return typeAnno.containsSubstitutableMethod(signature, access, fFunction, listParams) || typeOrig.containsSubstitutableMethod(signature, access, fFunction, listParams);
    }

    @Override
    public ClassTemplate getTemplate(Container container) {
        TypeConstant typeBase = this.getUnderlyingType();
        IdentityConstant constIdAnno = (IdentityConstant)this.getAnnotation().getAnnotationClass();
        ClassTemplate templateAnno = container.getTemplate(constIdAnno);
        return templateAnno instanceof xRef ? templateAnno.getTemplate(typeBase) : typeBase.getTemplate(container);
    }

    @Override
    public int callEquals(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return Utils.callEqualsSequence(frame, this.m_annotation.getAnnotationType(), this.m_constType, hValue1, hValue2, iReturn);
    }

    @Override
    public int callCompare(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return Utils.callCompareSequence(frame, this.m_annotation.getAnnotationType(), this.m_constType, hValue1, hValue2, iReturn);
    }

    @Override
    public int callHashCode(Frame frame, ObjectHandle hValue, int iReturn) {
        return this.m_constType.callHashCode(frame, hValue, iReturn);
    }

    @Override
    public MethodInfo findFunctionInfo(SignatureConstant sig) {
        MethodInfo info1 = this.m_annotation.getAnnotationType().findFunctionInfo(sig);
        MethodInfo info2 = this.m_constType.findFunctionInfo(sig);
        return info1 == null ? info2 : (info2 == null ? info1 : (info1.getIdentity().equals(info2.getIdentity()) ? info1 : null));
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.AnnotatedType;
    }

    @Override
    public boolean isValueCacheable() {
        return super.isValueCacheable() && !this.containsRegisterParameters();
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && (this.m_annotation.containsUnresolved() || this.m_constType.containsUnresolved());
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        this.m_annotation.forEachUnderlying(visitor);
        visitor.accept(this.m_constType);
    }

    @Override
    protected int compareDetails(Constant obj) {
        if (!(obj instanceof AnnotatedTypeConstant)) {
            return -1;
        }
        AnnotatedTypeConstant that = (AnnotatedTypeConstant)obj;
        int n = this.m_annotation.compareTo(that.m_annotation);
        if (n == 0) {
            n = this.m_constType.compareTo(that.m_constType);
        }
        return n;
    }

    @Override
    public String getValueString() {
        return this.m_annotation.getValueString() + " " + this.m_constType.getValueString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_annotation = (Annotation)pool.register(this.m_annotation);
        this.m_constType = (TypeConstant)pool.register(this.m_constType);
        this.m_typeAnno = null;
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, AnnotatedTypeConstant.indexOf(this.m_annotation));
        Handy.writePackedLong(out, AnnotatedTypeConstant.indexOf(this.m_constType));
    }

    @Override
    public boolean validate(ErrorListener errs) {
        if (!this.isValidated()) {
            TypeConstant typeInto;
            TypeConstant typeAnno;
            TypeConstant typeBase = this.m_constType.resolveTypedefs();
            if (typeBase.isFormalType()) {
                typeBase = ((FormalConstant)typeBase.getDefiningConstant()).getConstraintType();
            }
            if (!(typeBase instanceof AnnotatedTypeConstant) && !typeBase.isExplicitClassIdentity(true)) {
                this.log(errs, Severity.ERROR, "VERIFY-26", typeBase.getValueString());
                return true;
            }
            boolean fBad = this.m_annotation.validate(errs);
            ClassConstant idAnno = (ClassConstant)this.m_annotation.getAnnotationClass();
            TypeConstant typeNext = typeBase;
            while (typeNext instanceof AnnotatedTypeConstant) {
                typeAnno = (AnnotatedTypeConstant)typeNext;
                if (((AnnotatedTypeConstant)typeAnno).m_annotation.getAnnotationClass().equals(idAnno)) {
                    this.log(errs, Severity.ERROR, "VERIFY-28", idAnno.getValueString());
                    fBad = true;
                    break;
                }
                typeNext = ((AnnotatedTypeConstant)typeAnno).m_constType;
            }
            if (!fBad && !this.m_constType.isA(typeInto = (typeAnno = this.getAnnotationType()).getExplicitClassInto(true))) {
                this.log(errs, Severity.ERROR, "VERIFY-32", this.m_constType.getValueString(), idAnno.getValueString(), typeInto.getValueString());
                fBad = true;
            }
            if (!fBad) {
                return super.validate(errs);
            }
        }
        return false;
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_annotation, Hash.of(this.m_constType));
    }
}

