/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.constants.AbstractDependantChildTypeConstant;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeParameterConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class AnonymousClassTypeConstant
extends AbstractDependantChildTypeConstant {
    private transient int m_iAnon;
    protected ClassConstant m_idAnon;

    public AnonymousClassTypeConstant(ConstantPool pool, TypeConstant typeParent, ClassConstant idAnon) {
        super(pool, typeParent);
        if (typeParent.isAccessSpecified() || typeParent.isImmutabilitySpecified() || typeParent.isAnnotated()) {
            throw new IllegalArgumentException("parent's immutability, access or annotations cannot be specified");
        }
        if (idAnon == null) {
            throw new IllegalArgumentException("id is required");
        }
        this.m_idAnon = idAnon;
    }

    public AnonymousClassTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
        this.m_iAnon = Handy.readIndex(in);
    }

    public ClassConstant getChildClass() {
        return this.m_idAnon;
    }

    @Override
    protected void resolveConstants() {
        super.resolveConstants();
        this.m_idAnon = (ClassConstant)this.getConstantPool().getConstant(this.m_iAnon);
    }

    @Override
    protected ClassStructure getChildStructure() {
        return (ClassStructure)this.m_idAnon.getComponent();
    }

    @Override
    public boolean isShared(ConstantPool poolOther) {
        return super.isShared(poolOther) && this.m_idAnon.isShared(poolOther);
    }

    @Override
    public int getMaxParamsCount() {
        return 0;
    }

    @Override
    public boolean isAnonymousClass() {
        return true;
    }

    @Override
    protected TypeConstant cloneSingle(ConstantPool pool, TypeConstant type) {
        return pool.ensureAnonymousClassTypeConstant(type, this.m_idAnon);
    }

    @Override
    public TypeConstant adoptParameters(ConstantPool pool, TypeConstant[] atypeParams) {
        ClassStructure clz;
        if (atypeParams == null) {
            atypeParams = ConstantPool.NO_TYPES;
        }
        if ((clz = this.getChildStructure()).isParameterized()) {
            return pool.ensureParameterizedTypeConstant(this, clz.normalizeParameters(pool, atypeParams));
        }
        return this;
    }

    @Override
    public TypeConstant[] collectGenericParameters() {
        return null;
    }

    @Override
    public TypeConstant.Category getCategory() {
        return TypeConstant.Category.CLASS;
    }

    @Override
    public boolean isSingleUnderlyingClass(boolean fAllowInterface) {
        return true;
    }

    @Override
    public TypeConstant resolveFormalType(FormalConstant constFormal) {
        if (constFormal instanceof TypeParameterConstant) {
            TypeParameterConstant constParam = (TypeParameterConstant)constFormal;
            IdentityConstant identityConstant = this.getChildClass().getParentConstant();
            if (identityConstant instanceof MethodConstant) {
                TypeConstant typeActual;
                TypeConstant typeFormal;
                TypeConstant typeResolved;
                MethodConstant idMethod = (MethodConstant)identityConstant;
                if (constParam.getParentConstant().equals(idMethod) && (typeResolved = (typeFormal = idMethod.getType()).resolveTypeParameter(typeActual = this.getParentType(), constParam.getName())) != null) {
                    return typeResolved;
                }
            }
        }
        return super.resolveFormalType(constFormal);
    }

    @Override
    protected Set<SignatureConstant> isInterfaceAssignableFrom(TypeConstant typeRight, Constants.Access accessLeft, List<TypeConstant> listLeft) {
        throw new IllegalStateException();
    }

    @Override
    public TypeConstant.Usage checkConsumption(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return TypeConstant.Usage.NO;
    }

    @Override
    public TypeConstant.Usage checkProduction(String sTypeName, Constants.Access access, List<TypeConstant> listParams) {
        return TypeConstant.Usage.NO;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.AnonymousClassType;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        super.forEachUnderlying(visitor);
        visitor.accept(this.m_idAnon);
    }

    @Override
    protected int compareDetails(Constant obj) {
        int n = super.compareDetails(obj);
        if (n == 0) {
            if (!(obj instanceof AnonymousClassTypeConstant)) {
                return -1;
            }
            AnonymousClassTypeConstant that = (AnonymousClassTypeConstant)obj;
            n = this.m_idAnon.compareTo(that.m_idAnon);
        }
        return n;
    }

    @Override
    public String getValueString() {
        return this.m_typeParent.getValueString() + "." + this.m_idAnon.getValueString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        super.registerConstants(pool);
        this.m_idAnon = (ClassConstant)pool.register(this.m_idAnon);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        super.assemble(out);
        Handy.writePackedLong(out, this.m_idAnon.getPosition());
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_typeParent, Hash.of(this.m_idAnon));
    }
}

