/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.Version;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.MultiCondition;
import org.xvm.asm.constants.VersionedCondition;

public class AnyCondition
extends MultiCondition {
    public AnyCondition(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    public AnyCondition(ConstantPool pool, ConditionalConstant ... aconstCond) {
        super(pool, AnyCondition.mergeOrs(aconstCond));
    }

    private AnyCondition(ConditionalConstant[] acond) {
        super(acond[0].getConstantPool(), acond);
    }

    @Override
    public boolean evaluate(LinkerContext ctx) {
        for (ConditionalConstant constCond : this.m_aconstCond) {
            if (!constCond.evaluate(ctx)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean testEvaluate(long n) {
        for (ConditionalConstant constCond : this.m_aconstCond) {
            if (!constCond.testEvaluate(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Version> versions() {
        TreeSet<Version> setVers = null;
        Iterator<ConditionalConstant> iter = this.flatIterator();
        while (iter.hasNext()) {
            ConditionalConstant cond = iter.next();
            if (!(cond instanceof VersionedCondition)) continue;
            if (setVers == null) {
                setVers = new TreeSet<Version>();
            }
            setVers.add(((VersionedCondition)cond).getVersion());
        }
        return setVers == null ? Collections.emptySet() : setVers;
    }

    @Override
    public ConditionalConstant addVersion(Version ver) {
        if (this.versions().contains(ver)) {
            return this;
        }
        if (this.isOnlyVersions()) {
            ConditionalConstant[] acondOld = this.m_aconstCond;
            int cConds = acondOld.length;
            ConditionalConstant[] acondNew = new ConditionalConstant[cConds + 1];
            System.arraycopy(acondOld, 0, acondNew, 0, cConds);
            acondNew[cConds] = this.getConstantPool().ensureVersionedCondition(ver);
            return new AnyCondition(acondNew);
        }
        return super.addVersion(ver);
    }

    @Override
    public ConditionalConstant removeVersion(Version ver) {
        if (!this.versions().contains(ver)) {
            return this;
        }
        if (!this.isOnlyVersions()) {
            throw new IllegalStateException("version not allowed inside an arbitrary OR");
        }
        ConditionalConstant[] acondOld = this.m_aconstCond;
        int cConds = acondOld.length;
        switch (cConds) {
            case 0: 
            case 1: {
                throw new IllegalStateException("unexpectedly small AnyCondition: " + cConds);
            }
            case 2: {
                return ver.equals(((VersionedCondition)acondOld[0]).getVersion()) ? acondOld[1] : acondOld[0];
            }
        }
        ConditionalConstant[] acondNew = new ConditionalConstant[cConds - 1];
        int cNew = 0;
        for (ConditionalConstant constCond : acondOld) {
            VersionedCondition cond = (VersionedCondition)constCond;
            if (ver.equals(cond.getVersion())) continue;
            acondNew[cNew++] = cond;
        }
        assert (cNew == acondNew.length);
        return new AnyCondition(acondNew);
    }

    public boolean isOnlyVersions() {
        Iterator<ConditionalConstant> iter = this.flatIterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof VersionedCondition) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminalInfluenceBruteForce() {
        return !this.isOnlyVersions();
    }

    @Override
    protected boolean isTerminalInfluenceFinessable(boolean fInNot, Set<ConditionalConstant> setSimple, Set<ConditionalConstant> setComplex) {
        return !fInNot && this.isOnlyVersions();
    }

    @Override
    public Map<ConditionalConstant, ConditionalConstant.Influence> terminalInfluences() {
        if (this.isOnlyVersions()) {
            HashMap<ConditionalConstant, ConditionalConstant.Influence> influences = new HashMap<ConditionalConstant, ConditionalConstant.Influence>();
            Iterator<ConditionalConstant> iter = this.flatIterator();
            while (iter.hasNext()) {
                influences.put(iter.next(), ConditionalConstant.Influence.OR);
            }
            return influences;
        }
        return super.terminalInfluences();
    }

    @Override
    protected String getOperatorString() {
        return "||";
    }

    @Override
    protected AnyCondition instantiate(ConditionalConstant[] aconstCond) {
        return new AnyCondition(this.getConstantPool(), aconstCond);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.ConditionAny;
    }

    protected static ConditionalConstant[] mergeOrs(ConditionalConstant[] aconstCond) {
        assert (aconstCond != null);
        assert (aconstCond.length > 1);
        boolean fOrs = false;
        int cConds = 0;
        for (ConditionalConstant cond : aconstCond) {
            if (cond instanceof AnyCondition) {
                fOrs = true;
                cConds += AnyCondition.mergeOrs(((AnyCondition)cond).m_aconstCond).length;
                continue;
            }
            ++cConds;
        }
        if (!fOrs) {
            return aconstCond;
        }
        ConditionalConstant[] aconstMerged = new ConditionalConstant[cConds];
        int ofNew = 0;
        for (ConditionalConstant cond : aconstCond) {
            if (cond instanceof AnyCondition) {
                ConditionalConstant[] aconstCopy = AnyCondition.mergeOrs(((AnyCondition)cond).m_aconstCond);
                int cCopy = aconstCopy.length;
                System.arraycopy(aconstCopy, 0, aconstMerged, ofNew, cCopy);
                ofNew += cCopy;
                continue;
            }
            aconstMerged[ofNew++] = cond;
        }
        assert (ofNew == cConds);
        return aconstMerged;
    }
}

