/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class ArrayConstant
extends ValueConstant {
    private transient int m_iType;
    private transient int[] m_aiVal;
    private final Constant.Format f_fmt;
    private TypeConstant m_constType;
    private Constant[] m_aconstVal;

    public ArrayConstant(ConstantPool pool, Constant.Format fmt, TypeConstant constType, Constant ... aconstVal) {
        super(pool);
        this.validateFormatAndType(fmt, constType);
        if (aconstVal == null) {
            throw new IllegalArgumentException("value required");
        }
        this.f_fmt = fmt;
        this.m_constType = constType;
        this.m_aconstVal = aconstVal;
    }

    public ArrayConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        int iType = Handy.readMagnitude(in);
        int cVals = Handy.readMagnitude(in);
        int[] aiVal = new int[cVals];
        for (int i = 0; i < cVals; ++i) {
            aiVal[i] = Handy.readMagnitude(in);
        }
        this.f_fmt = format;
        this.m_iType = iType;
        this.m_aiVal = aiVal;
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_constType = (TypeConstant)pool.getConstant(this.m_iType);
        int[] aiConst = this.m_aiVal;
        int cConsts = aiConst.length;
        Constant[] aconst = new Constant[cConsts];
        for (int i = 0; i < cConsts; ++i) {
            aconst[i] = pool.getConstant(aiConst[i]);
        }
        this.m_aconstVal = aconst;
    }

    private void validateFormatAndType(Constant.Format fmt, TypeConstant constType) {
        if (fmt == null) {
            throw new IllegalArgumentException("format required");
        }
        if (constType == null) {
            throw new IllegalArgumentException("type required");
        }
        switch (fmt) {
            case Array: 
            case Tuple: 
            case Set: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported format: " + String.valueOf((Object)fmt));
            }
        }
        String sClassName = fmt.name();
        if (!constType.isEcstasy(sClassName)) {
            throw new IllegalArgumentException("type for " + String.valueOf((Object)fmt) + " must be " + sClassName + " (unsupported type: " + String.valueOf(constType) + ")");
        }
    }

    @Override
    public Constant convertTo(TypeConstant typeOut) {
        if (typeOut.isSingleDefiningConstant()) {
            ConstantPool pool = this.getConstantPool();
            if (typeOut.getDefiningConstant().equals(pool.clzArray())) {
                TypeConstant typeEl = typeOut.getParamType(0);
                Constant[] aconstIn = this.getValue();
                int cValues = aconstIn.length;
                Constant[] aconstOut = new Constant[cValues];
                for (int i = 0; i < cValues; ++i) {
                    Constant constEl = aconstIn[i].convertTo(typeEl);
                    if (constEl == null) {
                        return null;
                    }
                    aconstOut[i] = constEl;
                }
                return pool.ensureArrayConstant(typeOut, aconstOut);
            }
        }
        return null;
    }

    @Override
    public TypeConstant getType() {
        return this.m_constType;
    }

    public Constant[] getValue() {
        return this.m_aconstVal;
    }

    @Override
    public Constant.Format getFormat() {
        return this.f_fmt;
    }

    @Override
    public boolean isValueCacheable() {
        return !this.m_constType.containsFormalType(true);
    }

    @Override
    public boolean containsUnresolved() {
        if (this.isHashCached()) {
            return false;
        }
        if (this.m_constType.containsUnresolved()) {
            return true;
        }
        for (Constant constant : this.m_aconstVal) {
            if (!constant.containsUnresolved()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constType);
        for (Constant constant : this.m_aconstVal) {
            visitor.accept(constant);
        }
    }

    @Override
    public ArrayConstant resolveTypedefs() {
        TypeConstant typeOld = this.m_constType;
        TypeConstant typeNew = typeOld.resolveTypedefs();
        Constant[] aconstOld = this.m_aconstVal;
        Constant[] aconstNew = null;
        int c = aconstOld.length;
        for (int i = 0; i < c; ++i) {
            Constant constOld = aconstOld[i];
            Constant constNew = constOld.resolveTypedefs();
            if (constNew == constOld) continue;
            if (aconstNew == null) {
                aconstNew = (Constant[])aconstOld.clone();
            }
            aconstNew[i] = constNew;
        }
        return typeNew == typeOld && aconstNew == null ? this : (ArrayConstant)this.getConstantPool().register(new ArrayConstant(this.getConstantPool(), this.f_fmt, typeNew, aconstNew));
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof ArrayConstant)) {
            return -1;
        }
        int nResult = this.m_constType.compareTo(((ArrayConstant)that).m_constType);
        if (nResult != 0) {
            return nResult;
        }
        Constant[] aconstThis = this.m_aconstVal;
        Constant[] aconstThat = ((ArrayConstant)that).m_aconstVal;
        int cThis = aconstThis.length;
        int cThat = aconstThat.length;
        int c = Math.min(cThis, cThat);
        for (int i = 0; i < c; ++i) {
            nResult = aconstThis[i].compareTo(aconstThat[i]);
            if (nResult == 0) continue;
            return nResult;
        }
        return cThis - cThat;
    }

    @Override
    public String getValueString() {
        String sStart;
        Constant[] aconst = this.m_aconstVal;
        int cConsts = aconst.length;
        String sEnd = switch (this.f_fmt) {
            case Constant.Format.Array -> {
                sStart = "[";
                yield "]";
            }
            case Constant.Format.Tuple -> {
                sStart = cConsts < 2 ? "Tuple:(" : "(";
                yield ")";
            }
            case Constant.Format.Set -> {
                sStart = "Set:{";
                yield "}";
            }
            default -> throw new IllegalArgumentException("illegal format: " + String.valueOf((Object)this.f_fmt));
        };
        StringBuilder sb = new StringBuilder();
        sb.append(sStart);
        for (int i = 0; i < cConsts; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(aconst[i]);
        }
        sb.append(sEnd);
        return sb.toString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constType = (TypeConstant)pool.register(this.m_constType);
        this.m_aconstVal = ArrayConstant.registerConstants(pool, this.m_aconstVal);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constType.getPosition());
        Constant[] aconst = this.m_aconstVal;
        Handy.writePackedLong(out, aconst.length);
        for (Constant constant : aconst) {
            Handy.writePackedLong(out, constant.getPosition());
        }
    }

    @Override
    public String getDescription() {
        return "array-length=" + this.m_aconstVal.length;
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constType, Hash.of(this.m_aconstVal));
    }
}

