/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.util.Hash;

public class BFloat16Constant
extends ValueConstant {
    private final float m_flVal;

    public BFloat16Constant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_flVal = BFloat16Constant.toFloat(in.readUnsignedShort());
    }

    public BFloat16Constant(ConstantPool pool, float flVal) {
        super(pool);
        if (Float.isFinite(flVal) && !Float.isFinite(BFloat16Constant.toFloat(BFloat16Constant.toHalf(flVal)))) {
            throw new IllegalArgumentException("value out of range: " + flVal);
        }
        this.m_flVal = flVal;
    }

    public BFloat16Constant add(BFloat16Constant that) {
        return this.getConstantPool().ensureBFloat16Constant(this.m_flVal + that.m_flVal);
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.m_flVal);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.BFloat16;
    }

    @Override
    protected Object getLocator() {
        return this.getValue();
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof BFloat16Constant)) {
            return -1;
        }
        return Float.compare(this.m_flVal, ((BFloat16Constant)that).m_flVal);
    }

    @Override
    public String getValueString() {
        return Float.toString(this.m_flVal);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        out.writeShort(BFloat16Constant.toHalf(this.m_flVal));
    }

    @Override
    public String getDescription() {
        return "value=" + this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_flVal);
    }

    public static float toFloat(int nHalf) {
        return Float.intBitsToFloat(nHalf << 16);
    }

    public static int toHalf(float flVal) {
        int fbits = Float.floatToIntBits(flVal *= 1.001957f);
        return fbits >>> 16;
    }
}

