/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.LiteralConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.compiler.Token;
import org.xvm.util.Handy;
import org.xvm.util.Hash;
import org.xvm.util.PackedInteger;

public class ByteConstant
extends ValueConstant {
    private final Constant.Format m_format;
    private final int m_nVal;

    public ByteConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_format = format;
        this.m_nVal = ByteConstant.isSigned(format) ? in.readByte() : in.readUnsignedByte();
    }

    public ByteConstant(ConstantPool pool, Constant.Format format, int bVal) {
        super(pool);
        switch (format) {
            case Bit: {
                if ((bVal & 0xFFFFFFFE) != 0) {
                    throw new IllegalArgumentException("Bit must be in range 0..1");
                }
                bVal = bVal == 0 ? 0 : 1;
                break;
            }
            case Nibble: {
                if ((bVal & 0xFFFFFFF0) != 0) {
                    throw new IllegalArgumentException("Nibble must be in range 0..15");
                }
                bVal &= 0xF;
                break;
            }
            case Int8: {
                if (bVal >= -128 && bVal <= 127) break;
                throw new IllegalArgumentException("Int8 must be in range -128..127 (n=" + bVal + ")");
            }
            case UInt8: {
                if ((bVal & 0xFFFFFF00) != 0) {
                    throw new IllegalArgumentException("Byte must be in range 0..255");
                }
                bVal &= 0xFF;
                break;
            }
            default: {
                throw new IllegalArgumentException("format=" + String.valueOf((Object)format));
            }
        }
        this.m_format = format;
        this.m_nVal = bVal;
    }

    public int getMinLimit() {
        return ByteConstant.getMinLimit(this.m_format);
    }

    public static int getMinLimit(Constant.Format format) {
        return switch (format) {
            case Constant.Format.Int8 -> -128;
            case Constant.Format.Bit, Constant.Format.Nibble, Constant.Format.UInt8 -> 0;
            default -> throw new IllegalStateException();
        };
    }

    public int getMaxLimit() {
        return ByteConstant.getMaxLimit(this.m_format);
    }

    public static int getMaxLimit(Constant.Format format) {
        return switch (format) {
            case Constant.Format.Bit -> 1;
            case Constant.Format.Nibble -> 15;
            case Constant.Format.Int8 -> 127;
            case Constant.Format.UInt8 -> 255;
            default -> throw new IllegalStateException();
        };
    }

    public ByteConstant validate(int n) {
        int nMax;
        Constant.Format format = this.getFormat();
        boolean fSigned = ByteConstant.isSigned(format);
        int nMin = fSigned ? -128 : 0;
        int n2 = nMax = fSigned ? 127 : 255;
        if (n < nMin || n > nMax) {
            if (ByteConstant.isChecked(format)) {
                throw new ArithmeticException("overflow");
            }
            boolean fNeg = n < 0;
            n &= 0xFF;
            if (fNeg) {
                n |= 0xFFFFFF00;
            }
        }
        return this.getConstantPool().ensureByteConstant(this.m_format, n);
    }

    public ByteConstant validateNibble(int n) {
        if (n < 0 || n > 15) {
            throw new ArithmeticException("overflow");
        }
        return this.getConstantPool().ensureNibbleConstant(n);
    }

    static int nonzero(int n) {
        if (n == 0) {
            throw new ArithmeticException("zero");
        }
        return n;
    }

    private static boolean isSigned(Constant.Format format) {
        return format == Constant.Format.Int8;
    }

    private static boolean isChecked(Constant.Format format) {
        return format != Constant.Format.Int8 && format != Constant.Format.UInt8;
    }

    @Override
    public Integer getValue() {
        return this.m_nVal;
    }

    @Override
    public Constant.Format getFormat() {
        return this.m_format;
    }

    @Override
    public PackedInteger getIntValue() {
        return PackedInteger.valueOf(this.m_nVal);
    }

    @Override
    public Constant apply(Token.Id op, Constant that) {
        switch (that == null ? op.TEXT + this.getFormat().name() : this.getFormat().name() + op.TEXT + that.getFormat().name()) {
            case "-Int8": {
                return this.validate(-this.m_nVal);
            }
            case "~Int8": {
                return this.validate(~this.m_nVal);
            }
            case "Int8+IntLiteral": 
            case "Int8-IntLiteral": 
            case "Int8*IntLiteral": 
            case "Int8/IntLiteral": 
            case "Int8%IntLiteral": 
            case "Int8&IntLiteral": 
            case "Int8|IntLiteral": 
            case "Int8^IntLiteral": 
            case "Int8..IntLiteral": 
            case "Int8..<IntLiteral": 
            case "Int8==IntLiteral": 
            case "Int8!=IntLiteral": 
            case "Int8<IntLiteral": 
            case "Int8<=IntLiteral": 
            case "Int8>IntLiteral": 
            case "Int8>=IntLiteral": 
            case "Int8<=>IntLiteral": {
                return this.apply(op, ((LiteralConstant)that).toByteConstant(this.getFormat()));
            }
            case "Int8<<IntLiteral": 
            case "Int8>>IntLiteral": 
            case "Int8>>>IntLiteral": {
                return this.apply(op, ((LiteralConstant)that).toIntConstant(Constant.Format.Int64));
            }
            case "Int8+Int8": {
                return this.validate(this.m_nVal + ((ByteConstant)that).m_nVal);
            }
            case "Int8-Int8": {
                return this.validate(this.m_nVal - ((ByteConstant)that).m_nVal);
            }
            case "Int8*Int8": {
                return this.validate(this.m_nVal * ((ByteConstant)that).m_nVal);
            }
            case "Int8/Int8": {
                return this.validate(this.m_nVal / ByteConstant.nonzero(((ByteConstant)that).m_nVal));
            }
            case "Int8%Int8": {
                int nDivisor = ByteConstant.nonzero(((ByteConstant)that).m_nVal);
                int nModulo = this.m_nVal % nDivisor;
                return this.validate(nModulo < 0 ? nModulo + nDivisor : nModulo);
            }
            case "Int8&Int8": {
                return this.validate(this.m_nVal & ((ByteConstant)that).m_nVal);
            }
            case "Int8|Int8": {
                return this.validate(this.m_nVal | ((ByteConstant)that).m_nVal);
            }
            case "Int8^Int8": {
                return this.validate(this.m_nVal ^ ((ByteConstant)that).m_nVal);
            }
            case "Int8..Int8": {
                return ConstantPool.getCurrentPool().ensureRangeConstant(this, that);
            }
            case "Int8..<Int8": {
                return ConstantPool.getCurrentPool().ensureRangeConstant(this, false, that, true);
            }
            case "Int8<<Int64": {
                return this.validate(this.m_nVal << ((IntConstant)that).getValue().and(new PackedInteger(7L)).getInt());
            }
            case "Int8>>Int64": {
                return this.validate(this.m_nVal >> ((IntConstant)that).getValue().and(new PackedInteger(7L)).getInt());
            }
            case "Int8>>>Int64": {
                return this.validate(this.m_nVal >>> ((IntConstant)that).getValue().and(new PackedInteger(7L)).getInt());
            }
            case "Int8==Int8": {
                return this.getConstantPool().valOf(this.m_nVal == ((ByteConstant)that).m_nVal);
            }
            case "Int8!=Int8": {
                return this.getConstantPool().valOf(this.m_nVal != ((ByteConstant)that).m_nVal);
            }
            case "Int8<Int8": {
                return this.getConstantPool().valOf(this.m_nVal < ((ByteConstant)that).m_nVal);
            }
            case "Int8<=Int8": {
                return this.getConstantPool().valOf(this.m_nVal <= ((ByteConstant)that).m_nVal);
            }
            case "Int8>Int8": {
                return this.getConstantPool().valOf(this.m_nVal > ((ByteConstant)that).m_nVal);
            }
            case "Int8>=Int8": {
                return this.getConstantPool().valOf(this.m_nVal >= ((ByteConstant)that).m_nVal);
            }
            case "Int8<=>Int8": {
                return this.getConstantPool().valOrd(this.m_nVal - ((ByteConstant)that).m_nVal);
            }
            case "-UInt8": 
            case "~UInt8": {
                return this.validate(~this.m_nVal);
            }
            case "UInt8+IntLiteral": 
            case "UInt8-IntLiteral": 
            case "UInt8*IntLiteral": 
            case "UInt8/IntLiteral": 
            case "UInt8%IntLiteral": 
            case "UInt8&IntLiteral": 
            case "UInt8|IntLiteral": 
            case "UInt8^IntLiteral": 
            case "UInt8..IntLiteral": 
            case "UInt8..<IntLiteral": 
            case "UInt8==IntLiteral": 
            case "UInt8!=IntLiteral": 
            case "UInt8<IntLiteral": 
            case "UInt8<=IntLiteral": 
            case "UInt8>IntLiteral": 
            case "UInt8>=IntLiteral": 
            case "UInt8<=>IntLiteral": {
                return this.apply(op, ((LiteralConstant)that).toByteConstant(this.getFormat()));
            }
            case "UInt8<<IntLiteral": 
            case "UInt8>>IntLiteral": 
            case "UInt8>>>IntLiteral": {
                return this.apply(op, ((LiteralConstant)that).toIntConstant(Constant.Format.Int64));
            }
            case "UInt8+UInt8": {
                return this.validate(this.m_nVal + ((ByteConstant)that).m_nVal);
            }
            case "UInt8-UInt8": {
                return this.validate(this.m_nVal - ((ByteConstant)that).m_nVal);
            }
            case "UInt8*UInt8": {
                return this.validate(this.m_nVal * ((ByteConstant)that).m_nVal);
            }
            case "UInt8/UInt8": {
                return this.validate(this.m_nVal / ByteConstant.nonzero(((ByteConstant)that).m_nVal));
            }
            case "UInt8%UInt8": {
                return this.validate(this.m_nVal % ByteConstant.nonzero(((ByteConstant)that).m_nVal));
            }
            case "UInt8&UInt8": {
                return this.validate(this.m_nVal & ((ByteConstant)that).m_nVal);
            }
            case "UInt8|UInt8": {
                return this.validate(this.m_nVal | ((ByteConstant)that).m_nVal);
            }
            case "UInt8^UInt8": {
                return this.validate(this.m_nVal ^ ((ByteConstant)that).m_nVal);
            }
            case "UInt8..UInt8": 
            case "Nibble..Nibble": {
                return ConstantPool.getCurrentPool().ensureRangeConstant(this, that);
            }
            case "UInt8..<UInt8": {
                return ConstantPool.getCurrentPool().ensureRangeConstant(this, false, that, true);
            }
            case "UInt8>..UInt8": {
                return ConstantPool.getCurrentPool().ensureRangeConstant(this, true, that, false);
            }
            case "UInt8>..<UInt8": {
                return ConstantPool.getCurrentPool().ensureRangeConstant(this, true, that, true);
            }
            case "UInt8<<Int64": {
                return this.validate(this.m_nVal << ((IntConstant)that).getValue().and(new PackedInteger(7L)).getInt());
            }
            case "UInt8>>Int64": 
            case "UInt8>>>Int64": {
                return this.validate(this.m_nVal >>> ((IntConstant)that).getValue().and(new PackedInteger(7L)).getInt());
            }
            case "UInt8==UInt8": 
            case "Nibble==Nibble": {
                return this.getConstantPool().valOf(this.m_nVal == ((ByteConstant)that).m_nVal);
            }
            case "UInt8!=UInt8": 
            case "Nibble!=Nibble": {
                return this.getConstantPool().valOf(this.m_nVal != ((ByteConstant)that).m_nVal);
            }
            case "UInt8<UInt8": 
            case "Nibble<Nibble": {
                return this.getConstantPool().valOf(this.m_nVal < ((ByteConstant)that).m_nVal);
            }
            case "UInt8<=UInt8": 
            case "Nibble<=Nibble": {
                return this.getConstantPool().valOf(this.m_nVal <= ((ByteConstant)that).m_nVal);
            }
            case "UInt8>UInt8": 
            case "Nibble>Nibble": {
                return this.getConstantPool().valOf(this.m_nVal > ((ByteConstant)that).m_nVal);
            }
            case "UInt8>=UInt8": 
            case "Nibble>=Nibble": {
                return this.getConstantPool().valOf(this.m_nVal >= ((ByteConstant)that).m_nVal);
            }
            case "UInt8<=>UInt8": 
            case "Nibble<==>Nibble": {
                return this.getConstantPool().valOrd(this.m_nVal - ((ByteConstant)that).m_nVal);
            }
            case "Nibble+Nibble": {
                return this.validateNibble(this.m_nVal + ((ByteConstant)that).m_nVal);
            }
            case "Nibble-Nibble": {
                return this.validateNibble(this.m_nVal - ((ByteConstant)that).m_nVal);
            }
            case "Nibble*Nibble": {
                return this.validateNibble(this.m_nVal * ((ByteConstant)that).m_nVal);
            }
            case "Nibble/Nibble": {
                return this.validateNibble(this.m_nVal / ByteConstant.nonzero(((ByteConstant)that).m_nVal));
            }
            case "Bit+IntLiteral": 
            case "Bit-IntLiteral": 
            case "Nibble+IntLiteral": 
            case "Nibble-IntLiteral": {
                int delta = ((LiteralConstant)that).toIntConstant(Constant.Format.Int32).getIntValue().getInt();
                if (op == Token.Id.SUB) {
                    delta = -delta;
                }
                return this.m_format == Constant.Format.Bit ? this.getConstantPool().ensureBitConstant(this.m_nVal + delta) : this.getConstantPool().ensureNibbleConstant(this.m_nVal + delta);
            }
        }
        return super.apply(op, that);
    }

    @Override
    protected Object getLocator() {
        return this.getValue();
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof ByteConstant)) {
            return -1;
        }
        return this.m_nVal - ((ByteConstant)that).m_nVal;
    }

    @Override
    public String getValueString() {
        return switch (this.m_format) {
            case Constant.Format.Bit -> String.valueOf(this.m_nVal);
            case Constant.Format.Nibble -> "0x" + Handy.nibbleToChar(this.m_nVal);
            case Constant.Format.Int8 -> Integer.toString(this.m_nVal);
            default -> Handy.byteToHexString(this.m_nVal);
        };
    }

    @Override
    public Constant convertTo(TypeConstant typeOut) {
        Constant constant = super.convertTo(typeOut);
        if (constant != null) {
            return constant;
        }
        ConstantPool pool = this.getConstantPool();
        if (typeOut.equals(pool.typeInt8())) {
            return new ByteConstant(pool, Constant.Format.Int8, this.m_nVal);
        }
        if (typeOut.equals(pool.typeInt16())) {
            return IntConstant.toIntConstant(Constant.Format.Int16, new PackedInteger(this.m_nVal), pool);
        }
        if (typeOut.equals(pool.typeInt32())) {
            return IntConstant.toIntConstant(Constant.Format.Int32, new PackedInteger(this.m_nVal), pool);
        }
        if (typeOut.equals(pool.typeInt64())) {
            return IntConstant.toIntConstant(Constant.Format.Int64, new PackedInteger(this.m_nVal), pool);
        }
        if (typeOut.equals(pool.typeInt128())) {
            return IntConstant.toIntConstant(Constant.Format.Int128, new PackedInteger(this.m_nVal), pool);
        }
        if (typeOut.equals(pool.typeIntN())) {
            return IntConstant.toIntConstant(Constant.Format.IntN, new PackedInteger(this.m_nVal), pool);
        }
        if (typeOut.equals(pool.typeBit())) {
            return this.toByteConstant(Constant.Format.Bit);
        }
        if (typeOut.equals(pool.typeNibble())) {
            return this.toByteConstant(Constant.Format.Nibble);
        }
        if (typeOut.equals(pool.typeUInt8())) {
            return this.toByteConstant(Constant.Format.UInt8);
        }
        if (typeOut.equals(pool.typeUInt16())) {
            return IntConstant.toIntConstant(Constant.Format.UInt16, new PackedInteger(this.m_nVal), pool);
        }
        if (typeOut.equals(pool.typeUInt32())) {
            return IntConstant.toIntConstant(Constant.Format.UInt32, new PackedInteger(this.m_nVal), pool);
        }
        if (typeOut.equals(pool.typeUInt64())) {
            return IntConstant.toIntConstant(Constant.Format.UInt64, new PackedInteger(this.m_nVal), pool);
        }
        if (typeOut.equals(pool.typeUInt128())) {
            return IntConstant.toIntConstant(Constant.Format.UInt128, new PackedInteger(this.m_nVal), pool);
        }
        if (typeOut.equals(pool.typeUIntN())) {
            return IntConstant.toIntConstant(Constant.Format.UIntN, new PackedInteger(this.m_nVal), pool);
        }
        return null;
    }

    public ByteConstant toByteConstant(Constant.Format format) {
        int n = this.m_nVal;
        if (n < ByteConstant.getMinLimit(format) || n > ByteConstant.getMaxLimit(format)) {
            throw new ArithmeticException("out of range: " + n);
        }
        return this.getConstantPool().ensureByteConstant(format, n);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.m_format.ordinal());
        out.writeByte(this.m_nVal);
    }

    @Override
    public String getDescription() {
        return this.m_format.name() + "=" + this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_nVal);
    }
}

