/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataOutput;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.IntersectionTypeConstant;
import org.xvm.asm.constants.TypeConstant;

public class CastTypeConstant
extends IntersectionTypeConstant {
    private final TypeConstant m_constType1Orig;

    public CastTypeConstant(ConstantPool pool, TypeConstant constType1, TypeConstant constType2) {
        super(pool, constType2.combine(pool, constType1), constType2);
        this.m_constType1Orig = constType1;
    }

    @Override
    public TypeConstant resolveTypedefs() {
        return this.getUnderlyingType();
    }

    @Override
    protected TypeConstant.Relation calculateRelationToLeft(TypeConstant typeLeft) {
        return this.getUnderlyingType().calculateRelationToLeft(typeLeft);
    }

    @Override
    protected TypeConstant.Relation calculateRelationToRight(TypeConstant typeRight) {
        return this.getUnderlyingType().calculateRelationToRight(typeRight);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.CastType;
    }

    @Override
    protected void assemble(DataOutput out) {
        throw new IllegalStateException();
    }

    @Override
    public String getValueString() {
        return this.m_constType1Orig.getValueString() + ".as(" + this.m_constType2.getValueString() + ")";
    }
}

