/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.LiteralConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.compiler.Token;
import org.xvm.util.Handy;
import org.xvm.util.Hash;
import org.xvm.util.PackedInteger;

public class CharConstant
extends ValueConstant {
    private final int m_chVal;

    public CharConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_chVal = Handy.readUtf8Char(in);
    }

    public CharConstant(ConstantPool pool, int chVal) {
        super(pool);
        this.m_chVal = chVal;
    }

    @Override
    public Integer getValue() {
        return this.m_chVal;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Char;
    }

    @Override
    public PackedInteger getIntValue() {
        return PackedInteger.valueOf(this.m_chVal);
    }

    @Override
    public Constant apply(Token.Id op, Constant that) {
        switch (op.TEXT + that.getFormat().name()) {
            case "+String": {
                assert (Character.isValidCodePoint(this.m_chVal));
                String s = (char)this.m_chVal + ((StringConstant)that).getValue();
                return this.getConstantPool().ensureStringConstant(s);
            }
            case "+Char": {
                assert (Character.isValidCodePoint(this.m_chVal));
                assert (Character.isValidCodePoint(((CharConstant)that).m_chVal));
                char chThis = (char)this.m_chVal;
                char chThat = (char)((CharConstant)that).m_chVal;
                return this.getConstantPool().ensureStringConstant(String.valueOf(chThis) + chThat);
            }
            case "-Char": {
                assert (Character.isValidCodePoint(this.m_chVal));
                assert (Character.isValidCodePoint(((CharConstant)that).m_chVal));
                char chThis = (char)this.m_chVal;
                char chThat = (char)((CharConstant)that).m_chVal;
                return this.getConstantPool().ensureIntConstant(chThis - chThat);
            }
            case "*IntLiteral": 
            case "*Int64": {
                int n;
                assert (Character.isValidCodePoint(this.m_chVal));
                char ch = (char)this.m_chVal;
                int n2 = n = that.getFormat() == Constant.Format.IntLiteral ? ((LiteralConstant)that).getPackedInteger().getInt() : ((IntConstant)that).getValue().getInt();
                assert (n >= 0 && n < 1000000);
                char[] ach = new char[n];
                Arrays.fill(ach, ch);
                return this.getConstantPool().ensureStringConstant(new String(ach));
            }
            case "+IntLiteral": 
            case "-IntLiteral": {
                int delta = ((LiteralConstant)that).toIntConstant(Constant.Format.Int32).getIntValue().getInt();
                if (op == Token.Id.SUB) {
                    delta = -delta;
                }
                return this.getConstantPool().ensureCharConstant(this.m_chVal + delta);
            }
            case "==Char": {
                return this.getConstantPool().valOf(this.m_chVal == ((CharConstant)that).m_chVal);
            }
            case "!=Char": {
                return this.getConstantPool().valOf(this.m_chVal != ((CharConstant)that).m_chVal);
            }
            case "<Char": {
                return this.getConstantPool().valOf(this.m_chVal < ((CharConstant)that).m_chVal);
            }
            case "<=Char": {
                return this.getConstantPool().valOf(this.m_chVal <= ((CharConstant)that).m_chVal);
            }
            case ">Char": {
                return this.getConstantPool().valOf(this.m_chVal > ((CharConstant)that).m_chVal);
            }
            case ">=Char": {
                return this.getConstantPool().valOf(this.m_chVal >= ((CharConstant)that).m_chVal);
            }
            case "<=>Char": {
                return this.getConstantPool().valOrd(this.m_chVal - ((CharConstant)that).m_chVal);
            }
            case "..Char": {
                return this.getConstantPool().ensureRangeConstant(this, that);
            }
        }
        return super.apply(op, that);
    }

    @Override
    public Constant convertTo(TypeConstant typeOut) {
        switch (typeOut.getEcstasyClassName()) {
            case "text.String": {
                int ch = this.m_chVal;
                if (ch < 0 || ch > 65535) break;
                return this.getConstantPool().ensureStringConstant(Character.valueOf((char)ch).toString());
            }
        }
        return super.convertTo(typeOut);
    }

    @Override
    public TypeConstant getType() {
        return this.getConstantPool().typeChar();
    }

    @Override
    public Object getLocator() {
        return this.m_chVal <= 127 ? Character.valueOf((char)this.m_chVal) : null;
    }

    @Override
    protected int compareDetails(Constant constant) {
        if (!(constant instanceof CharConstant)) {
            return -1;
        }
        CharConstant that = (CharConstant)constant;
        return this.m_chVal - that.m_chVal;
    }

    @Override
    public String getValueString() {
        return this.m_chVal > 65535 ? Handy.appendIntAsHex(new StringBuilder("'\\U"), this.m_chVal).append('\'').toString() : Handy.quotedChar((char)this.m_chVal);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writeUtf8Char(out, this.m_chVal);
    }

    @Override
    public String getDescription() {
        return "char=" + this.getValueString() + ", index=" + this.m_chVal;
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_chVal);
    }
}

