/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class ChildClassConstant
extends PseudoConstant {
    private int m_iParent;
    private int m_iName;
    private PseudoConstant m_constParent;
    private StringConstant m_constName;

    public ChildClassConstant(ConstantPool pool, PseudoConstant constParent, String sName) {
        super(pool);
        if (constParent == null) {
            throw new IllegalArgumentException("parent required");
        }
        if (!constParent.isClass()) {
            throw new IllegalArgumentException("parent does not represent a class: " + String.valueOf(constParent));
        }
        if (!constParent.isAutoNarrowing()) {
            throw new IllegalArgumentException("parent is not auto-narrowing: " + String.valueOf(constParent));
        }
        if (sName == null) {
            throw new IllegalArgumentException("name required");
        }
        this.m_constParent = constParent;
        this.m_constName = pool.ensureStringConstant(sName);
    }

    public ChildClassConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iParent = Handy.readMagnitude(in);
        this.m_iName = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        ConstantPool pool = this.getConstantPool();
        this.m_constParent = (PseudoConstant)pool.getConstant(this.m_iParent);
        this.m_constName = (StringConstant)pool.getConstant(this.m_iName);
    }

    public PseudoConstant getParent() {
        return this.m_constParent;
    }

    public String getName() {
        return this.m_constName.getValue();
    }

    @Override
    public IdentityConstant getDeclarationLevelClass() {
        PseudoConstant constParent = this.m_constParent;
        switch (constParent.getFormat()) {
            case ParentClass: 
            case ThisClass: 
            case ChildClass: {
                IdentityConstant idParent = constParent.getDeclarationLevelClass();
                return idParent.getComponent().getChild(this.m_constName.getValue()).getIdentityConstant();
            }
        }
        throw new IllegalStateException("constParent=" + String.valueOf(constParent));
    }

    @Override
    public boolean isCongruentWith(PseudoConstant that) {
        if (that instanceof ChildClassConstant) {
            ChildClassConstant thatChild = (ChildClassConstant)that;
            return this.m_constParent.isCongruentWith(thatChild.m_constParent) && this.m_constName.equals(thatChild.m_constName);
        }
        return false;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.ChildClass;
    }

    @Override
    public TypeConstant getType() {
        return this.getConstantPool().ensureChildTypeConstant(this.m_constParent.getType(), this.m_constName.getValue());
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isAutoNarrowing() {
        return true;
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && (this.m_constParent.containsUnresolved() || this.m_constName.containsUnresolved());
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constParent);
        visitor.accept(this.m_constName);
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constParent, Hash.of(this.m_constName));
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof ChildClassConstant)) {
            return -1;
        }
        int nResult = this.m_constParent.compareTo(((ChildClassConstant)that).m_constParent);
        if (nResult == 0) {
            nResult = this.m_constName.compareTo(((ChildClassConstant)that).m_constName);
        }
        return nResult;
    }

    @Override
    public String getValueString() {
        return this.m_constParent.getValueString() + "." + this.getName();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_constParent = (PseudoConstant)pool.register(this.m_constParent);
        this.m_constName = (StringConstant)pool.register(this.m_constName);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.m_constParent.getPosition());
        Handy.writePackedLong(out, this.m_constName.getPosition());
    }

    @Override
    public String getDescription() {
        return "parent=" + String.valueOf(this.m_constParent) + ", child=" + this.getName();
    }
}

