/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constants;
import org.xvm.asm.TypedefStructure;
import org.xvm.asm.constants.IdentityConstant;

public class ChildInfo {
    Component f_child;
    Constants.Access f_access;
    Set<IdentityConstant> f_setIds;

    public ChildInfo(Component child) {
        this(child, child.getAccess(), Collections.singleton(child.getIdentityConstant()));
        assert (child instanceof ClassStructure || child instanceof TypedefStructure);
    }

    protected ChildInfo(Component child, Constants.Access access, Set<IdentityConstant> setIds) {
        this.f_child = child;
        this.f_access = access;
        this.f_setIds = setIds;
    }

    public String getName() {
        return this.f_child.getName();
    }

    public Constants.Access getAccess() {
        return this.f_access;
    }

    public IdentityConstant getIdentity() {
        return this.f_child.getIdentityConstant();
    }

    public Set<IdentityConstant> getAllIdentities() {
        return this.f_setIds;
    }

    public Component getComponent() {
        return this.f_child;
    }

    public boolean isVirtualClass() {
        return this.f_child instanceof ClassStructure && ((ClassStructure)this.f_child).isVirtualChildClass();
    }

    protected ChildInfo layerOn(ChildInfo that) {
        if (this.f_setIds.equals(that.f_setIds) || this.f_setIds.containsAll(that.f_setIds)) {
            return this;
        }
        if (that.f_setIds.containsAll(this.f_setIds)) {
            return that;
        }
        boolean fCombine = false;
        if (this.f_setIds.stream().anyMatch(id -> that.f_setIds.contains(id))) {
            fCombine = true;
        } else {
            Component component = this.f_child;
            if (component instanceof ClassStructure) {
                ClassStructure clzThis = (ClassStructure)component;
                component = that.f_child;
                if (component instanceof ClassStructure) {
                    ClassStructure clzThat = (ClassStructure)component;
                    if (clzThis.isStatic() == clzThat.isStatic()) {
                        if (clzThat.isStatic()) {
                            return that;
                        }
                        fCombine = clzThat.isExplicitlyOverride();
                    }
                }
            }
        }
        if (fCombine) {
            Component child = that.f_child;
            Constants.Access access = this.getAccess().maxOf(that.getAccess());
            HashSet<IdentityConstant> setIds = new HashSet<IdentityConstant>(this.f_setIds);
            setIds.addAll(that.f_setIds);
            return new ChildInfo(child, access, setIds);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ChildInfo)) return false;
        ChildInfo that = (ChildInfo)obj;
        if (!this.f_child.equals(that.f_child)) return false;
        if (!Objects.equals((Object)this.f_access, (Object)that.f_access)) return false;
        if (!Objects.equals(this.f_setIds, that.f_setIds)) return false;
        return true;
    }

    public String toString() {
        return "ChildInfo: " + String.valueOf((Object)this.getAccess()) + " " + this.getName();
    }
}

