/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.NamedConstant;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.ThisClassConstant;
import org.xvm.asm.constants.TypeConstant;

public class ClassConstant
extends NamedConstant {
    public ClassConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    public ClassConstant(ConstantPool pool, IdentityConstant constParent, String sName) {
        super(pool, constParent, sName);
        switch (constParent.getFormat()) {
            case Module: 
            case Package: 
            case Class: 
            case Method: 
            case Property: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid parent format: " + String.valueOf(constParent));
            }
        }
    }

    public MethodConstant findConstructor(TypeConstant ... types) {
        ClassStructure structClz = (ClassStructure)this.getComponent();
        if (structClz == null) {
            throw new IllegalStateException("could not find class " + String.valueOf(this));
        }
        return structClz.findConstructor(types).getIdentityConstant();
    }

    public ClassConstant getParentClass() {
        IdentityConstant parent = this.getParentConstant();
        block4: while (true) {
            switch (parent.getFormat()) {
                case Class: {
                    return (ClassConstant)parent;
                }
                case Method: 
                case Property: {
                    parent = parent.getNamespace();
                    continue block4;
                }
            }
            break;
        }
        return null;
    }

    public ClassConstant getOutermost() {
        ClassConstant outermost = this;
        IdentityConstant parent = this.getParentConstant();
        while (true) {
            switch (parent.getFormat()) {
                case Class: {
                    outermost = (ClassConstant)parent;
                    break;
                }
                case Method: 
                case Property: {
                    break;
                }
                default: {
                    return outermost;
                }
            }
            parent = parent.getNamespace();
        }
    }

    public int getDepthFromOutermost() {
        int cLevelsDown = 0;
        IdentityConstant parent = this.getParentConstant();
        block3: while (true) {
            switch (parent.getFormat()) {
                case Class: 
                case Method: 
                case Property: 
                case MultiMethod: {
                    ++cLevelsDown;
                    parent = parent.getParentConstant();
                    continue block3;
                }
            }
            break;
        }
        return cLevelsDown;
    }

    public ClassConstant getAutoNarrowingBase() {
        ClassConstant outermost = this;
        IdentityConstant parent = outermost.getParentConstant();
        while (true) {
            switch (parent.getFormat()) {
                case Class: {
                    outermost = (ClassConstant)parent;
                    break;
                }
                case Property: {
                    break;
                }
                default: {
                    return outermost;
                }
            }
            parent = parent.getParentConstant();
        }
    }

    public int getDepthFromAutoNarrowingBase() {
        int cLevelsDown = 0;
        IdentityConstant parent = this.getParentConstant();
        block3: while (true) {
            switch (parent.getFormat()) {
                case Class: 
                case Property: {
                    ++cLevelsDown;
                    parent = parent.getParentConstant();
                    continue block3;
                }
            }
            break;
        }
        return cLevelsDown;
    }

    public Constant calculateAutoNarrowingConstant(ClassConstant constThatClass) {
        int cThisDepth;
        ClassConstant constThatOutermost;
        ClassConstant constThisClass = this;
        if (!constThisClass.getComponent().isAutoNarrowingAllowed() || !constThatClass.getComponent().isAutoNarrowingAllowed()) {
            return constThatClass;
        }
        if (constThisClass.equals(constThatClass)) {
            return new ThisClassConstant(this.getConstantPool(), constThisClass);
        }
        ClassConstant constThisOutermost = constThisClass.getAutoNarrowingBase();
        if (!constThisOutermost.equals(constThatOutermost = constThatClass.getAutoNarrowingBase())) {
            return constThatClass;
        }
        ConstantPool pool = this.getConstantPool();
        PseudoConstant constPath = pool.ensureThisClassConstant(constThisClass);
        IdentityConstant constThis = constThisClass;
        IdentityConstant constThat = constThatClass;
        int cThatDepth = constThatClass.getDepthFromAutoNarrowingBase();
        int cReDescend = 0;
        for (cThisDepth = constThisClass.getDepthFromAutoNarrowingBase(); cThisDepth > cThatDepth; --cThisDepth) {
            constPath = pool.ensureParentClassConstant(constPath);
            constThis = constThis.getParentConstant();
        }
        while (cThatDepth > cThisDepth) {
            ++cReDescend;
            constThat = constThat.getParentConstant();
            --cThatDepth;
        }
        while (!constThis.equals(constThat)) {
            assert (cThisDepth == cThatDepth && cThisDepth >= 0);
            ++cReDescend;
            constPath = pool.ensureParentClassConstant(constPath);
            constThis = constThis.getParentConstant();
            constThat = constThat.getParentConstant();
            --cThisDepth;
            --cThatDepth;
        }
        return this.redescend(constPath, constThatClass, cReDescend);
    }

    private PseudoConstant redescend(PseudoConstant constPath, IdentityConstant constChild, int cLevels) {
        if (cLevels == 0) {
            return constPath;
        }
        if (cLevels > 1) {
            constPath = this.redescend(constPath, constChild.getParentConstant(), cLevels - 1);
        }
        return this.getConstantPool().ensureChildClassConstant(constPath, constChild.getName());
    }

    public String getImplicitImportName() {
        return this.getModuleConstant().isEcstasyModule() ? ConstantPool.getImplicitImportName("ecstasy." + this.getPathString()) : null;
    }

    @Override
    public IdentityConstant replaceParentConstant(IdentityConstant idParent) {
        return new ClassConstant(this.getConstantPool(), idParent, this.getName());
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Class;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public TypeConstant getType() {
        ClassStructure clz = (ClassStructure)this.getComponent();
        return clz.isVirtualChild() ? this.getConstantPool().ensureVirtualChildTypeConstant(this.getParentConstant().getType(), this.getName()) : (clz.isInnerChild() ? this.getConstantPool().ensureInnerChildTypeConstant(this.getParentConstant().getType(), this) : (clz.isAnonInnerClass() ? this.getConstantPool().ensureAnonymousClassTypeConstant(this.getParentConstant().getType(), this) : super.getType()));
    }

    @Override
    public IdentityConstant appendTrailingSegmentTo(IdentityConstant that) {
        return that.getConstantPool().ensureClassConstant(that, this.getName());
    }

    @Override
    public String getValueString() {
        String sImport = this.getImplicitImportName();
        return sImport == null ? super.getValueString() : sImport;
    }

    @Override
    public String getDescription() {
        IdentityConstant constParent = this.getNamespace();
        while (constParent instanceof ClassConstant) {
            ClassConstant idParent = (ClassConstant)constParent;
            constParent = idParent.getNamespace();
        }
        return "class=" + this.getValueString() + ", " + constParent.getDescription();
    }
}

