/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.Version;
import org.xvm.asm.constants.AllCondition;
import org.xvm.asm.constants.AnyCondition;
import org.xvm.asm.constants.MultiCondition;
import org.xvm.asm.constants.NotCondition;
import org.xvm.util.ListMap;
import org.xvm.util.LongList;

public abstract class ConditionalConstant
extends Constant {
    public transient int iTest;

    protected ConditionalConstant(ConstantPool pool) {
        super(pool);
    }

    public abstract boolean evaluate(LinkerContext var1);

    public boolean testEvaluate(long n) {
        assert (this.isTerminal());
        return this.iTest < 0 ? (n & 1L << -1 - this.iTest) == 0L : (n & 1L << this.iTest) != 0L;
    }

    public Set<ConditionalConstant> terminals() {
        if (this.isTerminal()) {
            return Collections.singleton(this);
        }
        HashSet<ConditionalConstant> terminals = new HashSet<ConditionalConstant>();
        this.collectTerminals(terminals);
        return terminals;
    }

    protected void collectTerminals(Set<ConditionalConstant> terminals) {
        assert (this.isTerminal());
        terminals.add(this);
    }

    public boolean containsTerminal(ConditionalConstant that) {
        return this.equals(that);
    }

    public boolean isTerminal() {
        return false;
    }

    public Relation calcRelation(ConditionalConstant that) {
        assert (!this.isTerminal());
        throw new UnsupportedOperationException("only terminal ConditionalConstants are supported");
    }

    public Set<Version> versions() {
        return Collections.emptySet();
    }

    public ConditionalConstant addVersion(Version ver) {
        if (this.versions().contains(ver)) {
            return this;
        }
        ConstantPool pool = this.getConstantPool();
        return new AllCondition(pool, this, pool.ensureVersionedCondition(ver));
    }

    public ConditionalConstant removeVersion(Version ver) {
        return this;
    }

    public ConditionalConstant addAnd(ConditionalConstant that) {
        if (this.equals(that)) {
            return this;
        }
        if (this instanceof AllCondition || that instanceof AllCondition) {
            ListMap<Object, Object> conds = new ListMap<Object, Object>();
            ConditionalConstant[] conditionalConstantArray = this;
            if (conditionalConstantArray instanceof AllCondition) {
                AllCondition thisAll = (AllCondition)conditionalConstantArray;
                for (ConditionalConstant cond : thisAll.m_aconstCond) {
                    conds.putIfAbsent(cond, cond);
                }
            } else {
                conds.put(this, this);
            }
            if (that instanceof AllCondition) {
                AllCondition thatAll = (AllCondition)that;
                for (ConditionalConstant cond : thatAll.m_aconstCond) {
                    conds.putIfAbsent(cond, cond);
                }
            } else {
                conds.putIfAbsent(that, that);
            }
            if (conds.size() == 1) {
                return (ConditionalConstant)conds.keySet().iterator().next();
            }
            return new AllCondition(this.getConstantPool(), conds.keySet().toArray(new ConditionalConstant[0]));
        }
        return new AllCondition(this.getConstantPool(), this, that);
    }

    public ConditionalConstant addOr(ConditionalConstant that) {
        if (this.equals(that)) {
            return this;
        }
        if (this instanceof AnyCondition || that instanceof AnyCondition) {
            ListMap<Object, Object> conds = new ListMap<Object, Object>();
            ConditionalConstant[] conditionalConstantArray = this;
            if (conditionalConstantArray instanceof AnyCondition) {
                AnyCondition thisAny = (AnyCondition)conditionalConstantArray;
                for (ConditionalConstant cond : thisAny.m_aconstCond) {
                    conds.putIfAbsent(cond, cond);
                }
            } else {
                conds.put(this, this);
            }
            if (that instanceof AnyCondition) {
                AnyCondition thatAny = (AnyCondition)that;
                for (ConditionalConstant cond : thatAny.m_aconstCond) {
                    conds.putIfAbsent(cond, cond);
                }
            } else {
                conds.putIfAbsent(that, that);
            }
            if (conds.size() == 1) {
                return (ConditionalConstant)conds.keySet().iterator().next();
            }
            return new AnyCondition(this.getConstantPool(), conds.keySet().toArray(new ConditionalConstant[0]));
        }
        return new AnyCondition(this.getConstantPool(), this, that);
    }

    public ConditionalConstant negate() {
        return this.getConstantPool().ensureNotCondition(this);
    }

    public boolean isTerminalInfluenceBruteForce() {
        assert (this.isTerminal());
        return false;
    }

    protected boolean isTerminalInfluenceFinessable(boolean fInNot, Set<ConditionalConstant> setSimple, Set<ConditionalConstant> setComplex) {
        assert (this.isTerminal());
        if (fInNot) {
            if (setSimple.contains(this) || setComplex.contains(this)) {
                return false;
            }
            setComplex.add(this);
            return true;
        }
        if (setComplex.contains(this)) {
            return false;
        }
        setSimple.add(this);
        return true;
    }

    public Map<ConditionalConstant, Influence> terminalInfluences() {
        if (this.isTerminal()) {
            return Collections.singletonMap(this, Influence.IDENTITY);
        }
        Set<ConditionalConstant> terminals = this.terminals();
        int cTerminals = terminals.size();
        ConditionalConstant[] acond = new ConditionalConstant[cTerminals];
        LongList skipMasks = new LongList();
        LongList skipPtrns = new LongList();
        int cConds = 0;
        block12: for (ConditionalConstant terminal : terminals) {
            int iCondThis;
            ListMap<Integer, Relation> conflicts = null;
            block13: for (int i = 0; i < cConds; ++i) {
                Relation rel = acond[i].calcRelation(terminal);
                switch (rel.ordinal()) {
                    case 0: {
                        continue block13;
                    }
                    case 1: {
                        terminal.iTest = i;
                        continue block12;
                    }
                    case 2: {
                        terminal.iTest = -1 - i;
                        continue block12;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (conflicts == null) {
                            conflicts = new ListMap<Integer, Relation>();
                        }
                        conflicts.put(i, rel);
                    }
                }
            }
            terminal.iTest = iCondThis = cConds++;
            acond[iCondThis] = terminal;
            if (conflicts == null) continue;
            for (Map.Entry entry : conflicts.entrySet()) {
                int iCondThat = (Integer)entry.getKey();
                skipMasks.add(1L << iCondThat | 1L << iCondThis);
                switch (((Relation)((Object)entry.getValue())).ordinal()) {
                    case 3: {
                        skipPtrns.add(1L << iCondThat | 1L << iCondThis);
                        break;
                    }
                    case 4: {
                        skipPtrns.add(0L);
                        break;
                    }
                    case 5: {
                        skipPtrns.add(1L << iCondThat);
                        break;
                    }
                    case 6: {
                        skipPtrns.add(1L << iCondThis);
                    }
                }
            }
        }
        long[] aResultFF = new long[cConds];
        long[] aResultFT = new long[cConds];
        long[] aResultTF = new long[cConds];
        long[] aResultTT = new long[cConds];
        this.bruteForce(cConds, skipMasks.toArray(), skipPtrns.toArray(), aResultFF, aResultFT, aResultTF, aResultTT);
        HashMap<ConditionalConstant, Influence> influences = new HashMap<ConditionalConstant, Influence>();
        for (ConditionalConstant terminal : terminals) {
            boolean fInvert;
            int iCond = terminal.iTest;
            boolean bl = fInvert = iCond < 0;
            if (fInvert) {
                iCond = -1 - iCond;
            }
            Influence influence = Influence.translate(aResultFF[iCond], aResultFT[iCond], aResultTF[iCond], aResultTT[iCond]);
            influences.put(terminal, fInvert ? influence.inverse() : influence);
        }
        return influences;
    }

    private void bruteForce(int cConds, long[] amaskSkip, long[] aptrnSkip, long[] aResultFF, long[] aResultFT, long[] aResultTF, long[] aResultTT) {
        assert (cConds > 0);
        int cSkips = amaskSkip.length;
        boolean fSkips = cSkips > 0;
        long cIters = 1L << cConds;
        block0: for (long nTest = 0L; nTest < cIters; ++nTest) {
            int iCond;
            if (fSkips) {
                for (int iSkip = 0; iSkip < cSkips; ++iSkip) {
                    if ((nTest & amaskSkip[iSkip]) == aptrnSkip[iSkip]) continue block0;
                }
            }
            if (this.testEvaluate(nTest)) {
                for (iCond = 0; iCond < cConds; ++iCond) {
                    if ((nTest & 1L << iCond) != 0L) {
                        int n = iCond;
                        aResultTT[n] = aResultTT[n] + 1L;
                        continue;
                    }
                    int n = iCond;
                    aResultFT[n] = aResultFT[n] + 1L;
                }
                continue;
            }
            for (iCond = 0; iCond < cConds; ++iCond) {
                if ((nTest & 1L << iCond) != 0L) {
                    int n = iCond;
                    aResultTF[n] = aResultTF[n] + 1L;
                    continue;
                }
                int n = iCond;
                aResultFF[n] = aResultFF[n] + 1L;
            }
        }
    }

    public Influence getSatisfiability() {
        Influence result = Influence.NONE;
        block3: for (Influence influence : this.terminalInfluences().values()) {
            switch (influence.ordinal()) {
                case 1: 
                case 9: {
                    assert (result == Influence.NONE || result == influence);
                    result = influence;
                    continue block3;
                }
            }
            return Influence.CONTRIB;
        }
        return result;
    }

    public Bifurcation bifurcate(ConditionalConstant that) {
        ConditionalConstant thisNeg;
        ConditionalConstant condThat;
        block15: {
            boolean fNegate = false;
            ConditionalConstant condThis = this;
            if (condThis instanceof NotCondition) {
                NotCondition condNot = (NotCondition)condThis;
                fNegate = !fNegate;
                condThis = condNot.getUnderlyingCondition();
            }
            if ((condThat = that) instanceof NotCondition) {
                NotCondition condNot = (NotCondition)condThat;
                fNegate = !fNegate;
                condThat = condNot.getUnderlyingCondition();
            }
            if (condThis.isTerminal() && condThat.isTerminal()) {
                switch (condThis.calcRelation(condThat).ordinal()) {
                    case 2: {
                        fNegate = !fNegate;
                    }
                    case 1: {
                        return new Bifurcation(!fNegate, null, fNegate, null);
                    }
                }
                return new Bifurcation(true, condThat, true, condThat);
            }
            thisNeg = this.negate();
            if (that instanceof AllCondition) {
                AllCondition thatAll = (AllCondition)that;
                if (that.terminals().containsAll(this.terminals())) {
                    ConditionalConstant[] acondThat = thatAll.m_aconstCond;
                    int c22 = acondThat.length;
                    for (int i = 0; i < c22; ++i) {
                        ConditionalConstant cond = acondThat[i];
                        if (cond.equals(this)) {
                            return new Bifurcation(true, thatAll.remove(i), false, null);
                        }
                        if (!cond.equals(thisNeg)) continue;
                        return new Bifurcation(false, null, true, thatAll.remove(i));
                    }
                    ConditionalConstant c22 = this;
                    if (c22 instanceof AllCondition) {
                        AllCondition thisAll = (AllCondition)c22;
                        ConditionalConstant condReduced = that;
                        ConditionalConstant[] acondThis = thisAll.m_aconstCond;
                        if (acondThis.length < acondThat.length) {
                            ConditionalConstant[] conditionalConstantArray = acondThis;
                            int n = conditionalConstantArray.length;
                            for (int i = 0; i < n; ++i) {
                                MultiCondition condBefore = (MultiCondition)condReduced;
                                ConditionalConstant consCond = conditionalConstantArray[i];
                                if ((condReduced = condBefore.remove(consCond)) != condBefore) {
                                    continue;
                                }
                                break block15;
                            }
                            return new Bifurcation(true, condReduced, false, null);
                        }
                    }
                }
            }
        }
        Influence influenceTrue = this.addAnd(that).getSatisfiability();
        Influence influenceFalse = thisNeg.addAnd(that).getSatisfiability();
        return new Bifurcation(influenceTrue != Influence.ALWAYS_F, condThat, influenceFalse != Influence.ALWAYS_F, condThat);
    }

    @Override
    public String getDescription() {
        return "condition=" + this.getValueString();
    }

    public static enum Influence {
        NONE,
        ALWAYS_F,
        AND,
        IDENTITY,
        INV_AND,
        CONTRIB,
        OR,
        INVERSE,
        INV_OR,
        ALWAYS_T;


        public Influence inverse() {
            return switch (this.ordinal()) {
                case 2 -> INV_OR;
                case 4 -> OR;
                case 6 -> INV_AND;
                case 8 -> AND;
                case 3 -> INVERSE;
                case 7 -> IDENTITY;
                case 1 -> ALWAYS_T;
                case 9 -> ALWAYS_F;
                default -> this;
            };
        }

        public Influence and() {
            return switch (this.ordinal()) {
                case 6, 8, 9 -> CONTRIB;
                case 7 -> INV_AND;
                case 3 -> AND;
                default -> this;
            };
        }

        public boolean isRequired() {
            return this == AND || this == IDENTITY;
        }

        public static Influence translate(long cFalseInFalseOut, long cFalseInTrueOut, long cTrueInFalseOut, long cTrueInTrueOut) {
            return switch ((cFalseInFalseOut == 0L ? 0 : 8) | (cFalseInTrueOut == 0L ? 0 : 4) | (cTrueInFalseOut == 0L ? 0 : 2) | (cTrueInTrueOut == 0L ? 0 : 1)) {
                case 0 -> NONE;
                case 1 -> ALWAYS_T;
                case 4 -> ALWAYS_T;
                case 5 -> ALWAYS_T;
                case 2 -> ALWAYS_F;
                case 8 -> ALWAYS_F;
                case 10 -> ALWAYS_F;
                case 6 -> INVERSE;
                case 7 -> INV_OR;
                case 9 -> IDENTITY;
                case 11 -> AND;
                case 13 -> OR;
                case 14 -> INV_AND;
                case 3 -> CONTRIB;
                case 12 -> CONTRIB;
                case 15 -> CONTRIB;
                default -> CONTRIB;
            };
        }
    }

    public static enum Relation {
        INDEP,
        EQUIV,
        INVERSE,
        MUTEX,
        MUTIN,
        IMPLIES,
        IMPLIED;


        public Relation reverse() {
            return switch (this.ordinal()) {
                case 5 -> IMPLIED;
                case 6 -> IMPLIES;
                default -> this;
            };
        }

        public Relation inverse() {
            return switch (this.ordinal()) {
                case 3 -> MUTIN;
                case 4 -> MUTEX;
                default -> this;
            };
        }
    }

    public static class Bifurcation {
        private final boolean fTruePossible;
        private final ConditionalConstant condTrue;
        private final boolean fFalsePossible;
        private final ConditionalConstant condFalse;

        public Bifurcation(boolean fTruePossible, ConditionalConstant condTrue, boolean fFalsePossible, ConditionalConstant condFalse) {
            this.fTruePossible = fTruePossible;
            this.condTrue = condTrue;
            this.fFalsePossible = fFalsePossible;
            this.condFalse = condFalse;
        }

        public boolean isTruePossible() {
            return this.fTruePossible;
        }

        public ConditionalConstant getTrueCondition() {
            return this.condTrue;
        }

        public boolean isFalsePossible() {
            return this.fFalsePossible;
        }

        public ConditionalConstant getFalseCondition() {
            return this.condFalse;
        }
    }
}

