/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.DecimalConstant;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.compiler.Token;
import org.xvm.type.Decimal;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class DecimalAutoConstant
extends ValueConstant {
    private DecimalConstant m_dec;

    public DecimalAutoConstant(ConstantPool pool, Decimal dec) {
        this(pool, pool.ensureDecConstant(dec));
    }

    public DecimalAutoConstant(ConstantPool pool, DecimalConstant dec) {
        super(pool);
        this.m_dec = dec;
    }

    public DecimalAutoConstant add(DecimalAutoConstant that) {
        return this.getConstantPool().ensureDecAConstant(this.getValue().add(that.getValue()));
    }

    @Override
    public Decimal getValue() {
        return this.m_dec.getValue();
    }

    @Override
    public Constant apply(Token.Id op, Constant that) {
        switch (that == null ? op.TEXT + this.getFormat().name() : this.getFormat().name() + op.TEXT + that.getFormat().name()) {
            case "+Dec": {
                return this;
            }
            case "-Dec": {
                return this.getConstantPool().ensureDecAConstant(this.getValue().neg());
            }
            case "Dec+Dec": {
                return this.getConstantPool().ensureDecAConstant(this.getValue().add(((DecimalAutoConstant)that).getValue()));
            }
            case "Dec-Dec": {
                return this.getConstantPool().ensureDecAConstant(this.getValue().subtract(((DecimalAutoConstant)that).getValue()));
            }
            case "Dec*Dec": {
                return this.getConstantPool().ensureDecAConstant(this.getValue().multiply(((DecimalAutoConstant)that).getValue()));
            }
            case "Dec/Dec": {
                return this.getConstantPool().ensureDecAConstant(this.getValue().divide(((DecimalAutoConstant)that).getValue()));
            }
            case "Dec%Dec": {
                return this.getConstantPool().ensureDecAConstant(this.getValue().mod(((DecimalAutoConstant)that).getValue()));
            }
            case "Dec^Dec": {
                return this.getConstantPool().ensureDecAConstant(this.getValue().pow(((DecimalAutoConstant)that).getValue()));
            }
            case "Dec..Dec": {
                return this.getConstantPool().ensureRangeConstant(this, that);
            }
            case "Dec==Dec": 
            case "Dec!=Dec": 
            case "Dec<Dec": 
            case "Dec<=Dec": 
            case "Dec>Dec": 
            case "Dec>=Dec": 
            case "Dec<==>Dec": {
                return this.translateOrder(this.getValue().compareForObjectOrder(((DecimalAutoConstant)that).getValue()), op);
            }
        }
        return super.apply(op, that);
    }

    @Override
    protected Object getLocator() {
        return this.m_dec;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Dec64;
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof DecimalAutoConstant)) {
            return -1;
        }
        return this.getValue().compareForObjectOrder(((DecimalAutoConstant)that).getValue());
    }

    @Override
    public String getValueString() {
        return this.m_dec.getValueString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_dec = (DecimalConstant)pool.register(this.m_dec);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(Constant.Format.Dec64.ordinal());
        Handy.writePackedLong(out, this.m_dec.getPosition());
    }

    @Override
    public String getDescription() {
        return "value=" + this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_dec);
    }
}

