/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.compiler.Token;
import org.xvm.type.Decimal;
import org.xvm.type.Decimal128;
import org.xvm.type.Decimal32;
import org.xvm.type.Decimal64;
import org.xvm.util.Hash;

public class DecimalConstant
extends ValueConstant {
    private final Decimal m_dec;

    public DecimalConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        switch (format) {
            case Dec32: {
                this.m_dec = new Decimal32(in);
                break;
            }
            case Dec64: {
                this.m_dec = new Decimal64(in);
                break;
            }
            case Dec128: {
                this.m_dec = new Decimal128(in);
                break;
            }
            default: {
                throw new IOException("unsupported format: " + String.valueOf((Object)format));
            }
        }
    }

    public DecimalConstant(ConstantPool pool, Decimal dec) {
        super(pool);
        switch (dec.getBitLength()) {
            case 32: 
            case 64: 
            case 128: {
                this.m_dec = dec;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported decimal length: " + dec.getBitLength());
            }
        }
    }

    public DecimalConstant add(DecimalConstant that) {
        if (this.getFormat() != that.getFormat()) {
            throw new IllegalStateException();
        }
        return this.getConstantPool().ensureDecConstant(this.m_dec.add(that.m_dec));
    }

    @Override
    public Decimal getValue() {
        return this.m_dec;
    }

    @Override
    public Constant apply(Token.Id op, Constant that) {
        switch (that == null ? op.TEXT + this.getFormat().name() : this.getFormat().name() + op.TEXT + that.getFormat().name()) {
            case "+Dec32": 
            case "+Dec64": 
            case "+Dec128": {
                return this;
            }
            case "-Dec32": 
            case "-Dec64": 
            case "-Dec128": {
                return this.getConstantPool().ensureDecConstant(this.getValue().neg());
            }
            case "Dec32+Dec32": 
            case "Dec64+Dec64": 
            case "Dec128+Dec128": {
                return this.getConstantPool().ensureDecConstant(this.getValue().add(((DecimalConstant)that).getValue()));
            }
            case "Dec32-Dec32": 
            case "Dec64-Dec64": 
            case "Dec128-Dec128": {
                return this.getConstantPool().ensureDecConstant(this.getValue().subtract(((DecimalConstant)that).getValue()));
            }
            case "Dec32*Dec32": 
            case "Dec64*Dec64": 
            case "Dec128*Dec128": {
                return this.getConstantPool().ensureDecConstant(this.getValue().multiply(((DecimalConstant)that).getValue()));
            }
            case "Dec32/Dec32": 
            case "Dec64/Dec64": 
            case "Dec128/Dec128": {
                return this.getConstantPool().ensureDecConstant(this.getValue().divide(((DecimalConstant)that).getValue()));
            }
            case "Dec32%Dec32": 
            case "Dec64%Dec64": 
            case "Dec128%Dec128": {
                return this.getConstantPool().ensureDecConstant(this.getValue().mod(((DecimalConstant)that).getValue()));
            }
            case "Dec32^Dec32": 
            case "Dec64^Dec64": 
            case "Dec128^Dec128": {
                return this.getConstantPool().ensureDecConstant(this.getValue().pow(((DecimalConstant)that).getValue()));
            }
            case "Dec32..Dec32": 
            case "Dec64..Dec64": 
            case "Dec128..Dec128": {
                return this.getConstantPool().ensureRangeConstant(this, that);
            }
            case "Dec32==Dec32": 
            case "Dec64==Dec64": 
            case "Dec128==Dec128": 
            case "Dec32!=Dec32": 
            case "Dec64!=Dec64": 
            case "Dec128!=Dec128": 
            case "Dec32<Dec32": 
            case "Dec64<Dec64": 
            case "Dec128<Dec128": 
            case "Dec32<=Dec32": 
            case "Dec64<=Dec64": 
            case "Dec128<=Dec128": 
            case "Dec32>Dec32": 
            case "Dec64>Dec64": 
            case "Dec128>Dec128": 
            case "Dec32>=Dec32": 
            case "Dec64>=Dec64": 
            case "Dec128>=Dec128": 
            case "Dec32<==>Dec32": 
            case "Dec64<==>Dec64": 
            case "Dec128<==>Dec128": {
                return this.translateOrder(this.getValue().compareForObjectOrder(((DecimalConstant)that).getValue()), op);
            }
        }
        return super.apply(op, that);
    }

    @Override
    protected Object getLocator() {
        return this.m_dec;
    }

    @Override
    public Constant.Format getFormat() {
        return switch (this.m_dec.getBitLength()) {
            case 32 -> Constant.Format.Dec32;
            case 64 -> Constant.Format.Dec64;
            case 128 -> Constant.Format.Dec128;
            default -> throw new IllegalStateException("unsupported decimal length: " + this.m_dec.getBitLength());
        };
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof DecimalConstant)) {
            return -1;
        }
        return this.m_dec.compareForObjectOrder(((DecimalConstant)that).m_dec);
    }

    @Override
    public String getValueString() {
        return this.m_dec.toString();
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        this.m_dec.writeBytes(out);
    }

    @Override
    public String getDescription() {
        return "value=" + this.getValueString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_dec);
    }
}

