/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class DecoratedClassConstant
extends IdentityConstant {
    private int m_iType;
    TypeConstant m_type;

    public DecoratedClassConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool);
        this.m_iType = Handy.readMagnitude(in);
    }

    public DecoratedClassConstant(ConstantPool pool, TypeConstant type) {
        super(pool);
        assert (type.isSingleDefiningConstant());
        this.m_type = type;
    }

    @Override
    protected void resolveConstants() {
        this.m_type = (TypeConstant)this.getConstantPool().getConstant(this.m_iType);
        super.resolveConstants();
    }

    @Override
    public IdentityConstant replaceParentConstant(IdentityConstant idParent) {
        return this;
    }

    IdentityConstant getClassIdentityConstant() {
        return (IdentityConstant)this.m_type.getDefiningConstant();
    }

    @Override
    public String getName() {
        return this.getClassIdentityConstant().getName();
    }

    public boolean isVirtualChild() {
        return this.m_type.isVirtualChild();
    }

    @Override
    public Component getComponent() {
        return this.getClassIdentityConstant().getComponent();
    }

    @Override
    public IdentityConstant getParentConstant() {
        return this.isVirtualChild() ? this.getConstantPool().ensureClassConstant(this.m_type.getParentType()) : this.getClassIdentityConstant().getParentConstant();
    }

    @Override
    public TypeConstant getFormalType() {
        return this.getType();
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.DecoratedClass;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public TypeConstant getType() {
        return this.m_type;
    }

    @Override
    public IdentityConstant appendTrailingSegmentTo(IdentityConstant that) {
        ConstantPool pool = that.getConstantPool();
        return pool.ensureClassConstant(that, this.getName());
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && this.m_type.containsUnresolved();
    }

    @Override
    protected Object getLocator() {
        return this.m_type;
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof DecoratedClassConstant)) {
            return -1;
        }
        return this.m_type.compareTo(((DecoratedClassConstant)that).m_type);
    }

    @Override
    public String getValueString() {
        return this.getType().getValueString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        this.m_type = (TypeConstant)pool.register(this.m_type);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        super.assemble(out);
        Handy.writePackedLong(out, this.m_type.getPosition());
    }

    @Override
    public String getDescription() {
        IdentityConstant constParent = this.getNamespace();
        while (constParent instanceof ClassConstant) {
            constParent = ((ClassConstant)constParent).getNamespace();
        }
        return constParent == null ? "class=" + this.getValueString() : "class=" + this.getValueString() + ", " + constParent.getDescription();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_type);
    }
}

