/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.Annotation;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.ChildInfo;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.ParamInfo;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.RelationalTypeConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.UnionTypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.ListMap;

public class DifferenceTypeConstant
extends RelationalTypeConstant {
    public DifferenceTypeConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    public DifferenceTypeConstant(ConstantPool pool, TypeConstant constType1, TypeConstant constType2) {
        super(pool, constType1, constType2);
    }

    @Override
    protected TypeConstant cloneRelational(ConstantPool pool, TypeConstant type1, TypeConstant type2) {
        return pool.ensureDifferenceTypeConstant(type1, type2);
    }

    @Override
    protected TypeConstant simplifyInternal(TypeConstant type1, TypeConstant type2) {
        TypeConstant typeResult;
        if (type1 instanceof DifferenceTypeConstant) {
            DifferenceTypeConstant typeDiff = (DifferenceTypeConstant)type1;
            return typeDiff.andNotInternal(type2);
        }
        if (type1.isImmutabilitySpecified() && type2.isOnlyImmutable()) {
            return type1.removeImmutable();
        }
        if ((type1.isRelationalType() || type1.isAnnotated()) && (typeResult = type1.andNot(this.getConstantPool(), type2)) != type1) {
            return typeResult;
        }
        return null;
    }

    @Override
    public boolean isImmutabilitySpecified() {
        return this.m_constType1.isImmutabilitySpecified();
    }

    @Override
    public boolean isImmutable() {
        return this.m_constType1.isImmutable();
    }

    @Override
    public TypeConstant removeImmutable() {
        return this.cloneRelational(this.getConstantPool(), this.m_constType1.removeImmutable(), this.m_constType2);
    }

    @Override
    public TypeConstant freeze() {
        TypeConstant typeOriginal1 = this.m_constType1;
        TypeConstant typeOriginal2 = this.m_constType2;
        TypeConstant typeImmutable1 = typeOriginal1.freeze();
        return typeOriginal1 == typeImmutable1 ? this : this.cloneRelational(this.getConstantPool(), typeImmutable1, typeOriginal2);
    }

    @Override
    public boolean isIncompatibleCombo(TypeConstant that) {
        return false;
    }

    @Override
    public boolean extendsClass(IdentityConstant constClass) {
        return false;
    }

    @Override
    public TypeConstant.Category getCategory() {
        TypeConstant.Category cat1 = this.m_constType1.getCategory();
        TypeConstant.Category cat2 = this.m_constType2.getCategory();
        return switch (cat1) {
            case TypeConstant.Category.CLASS, TypeConstant.Category.IFACE -> {
                switch (cat2) {
                    case CLASS: 
                    case IFACE: {
                        yield TypeConstant.Category.IFACE;
                    }
                }
                yield TypeConstant.Category.OTHER;
            }
            default -> TypeConstant.Category.OTHER;
        };
    }

    @Override
    public boolean isSingleUnderlyingClass(boolean fAllowInterface) {
        return false;
    }

    @Override
    public IdentityConstant getSingleUnderlyingClass(boolean fAllowInterface) {
        throw new IllegalStateException();
    }

    @Override
    public boolean isConst() {
        return this.m_constType1.isConst();
    }

    @Override
    public boolean isOnlyNullable() {
        return false;
    }

    @Override
    public TypeConstant andNot(ConstantPool pool, TypeConstant that) {
        TypeConstant typeR = this.andNotInternal(that);
        return typeR == null ? super.andNot(pool, that) : typeR;
    }

    private TypeConstant andNotInternal(TypeConstant that) {
        TypeConstant type1 = this.m_constType1.resolveTypedefs();
        TypeConstant type2 = this.m_constType2.resolveTypedefs();
        if (that.isA(type1)) {
            return this.getConstantPool().typeObject();
        }
        if (type2.isA(that)) {
            return this;
        }
        return null;
    }

    @Override
    public boolean containsGenericParam(String sName) {
        return this.m_constType1.containsGenericParam(sName);
    }

    @Override
    protected TypeConstant getGenericParamType(String sName, List<TypeConstant> listParams) {
        return this.m_constType1.getGenericParamType(sName, listParams);
    }

    @Override
    public ComponentResolver.ResolutionResult resolveContributedName(String sName, Constants.Access access, MethodConstant idMethod, ComponentResolver.ResolutionCollector collector) {
        ErrorListener errs = collector.getErrorListener();
        Component.SimpleCollector collector1 = new Component.SimpleCollector(errs);
        ComponentResolver.ResolutionResult result1 = this.m_constType1.resolveContributedName(sName, access, idMethod, collector1);
        if (result1 == ComponentResolver.ResolutionResult.RESOLVED) {
            ComponentResolver.ResolutionResult result2 = this.m_constType2.resolveContributedName(sName, access, idMethod, new Component.SimpleCollector(errs));
            if (result2 == ComponentResolver.ResolutionResult.RESOLVED) {
                return ComponentResolver.ResolutionResult.UNKNOWN;
            }
            collector.resolvedConstant(collector1.getResolvedConstant());
        }
        return result1;
    }

    @Override
    public TypeConstant resolveTypeParameter(TypeConstant typeActual, String sFormalName) {
        typeActual = typeActual.resolveTypedefs();
        if (this.getFormat() != typeActual.getFormat()) {
            return null;
        }
        DifferenceTypeConstant that = (DifferenceTypeConstant)typeActual;
        return this.m_constType1.resolveTypeParameter(that.m_constType1, sFormalName);
    }

    @Override
    public boolean isNestMateOf(IdentityConstant idClass) {
        TypeConstant type1 = this.m_constType1;
        if (type1.isFormalType()) {
            type1 = ((FormalConstant)type1.getDefiningConstant()).getConstraintType();
        }
        return type1.isNestMateOf(idClass);
    }

    @Override
    public boolean containsFunctionType() {
        return false;
    }

    @Override
    public TypeInfo ensureTypeInfo(IdentityConstant idClass, ErrorListener errs) {
        TypeConstant type1 = this.m_constType1;
        if (type1.isFormalType()) {
            TypeConstant typeC = ((FormalConstant)type1.getDefiningConstant()).getConstraintType();
            TypeConstant typeN = typeC.andNot(this.getConstantPool(), this.m_constType2);
            return typeN.ensureTypeInfo(idClass, errs);
        }
        return super.ensureTypeInfo(idClass, errs);
    }

    @Override
    protected Map<Object, ParamInfo> mergeTypeParams(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        if (info1 == null || info2 == null) {
            return Collections.emptyMap();
        }
        Map<Object, ParamInfo> map1 = info1.getTypeParams();
        Map<Object, ParamInfo> map2 = info2.getTypeParams();
        HashMap<Object, ParamInfo> map = new HashMap<Object, ParamInfo>(map1);
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object nid = entry.getKey();
            ParamInfo param2 = map2.get(nid);
            if (param2 == null) continue;
            ParamInfo param1 = (ParamInfo)entry.getValue();
            TypeConstant type1 = param1.getActualType();
            TypeConstant type2 = param2.getActualType();
            if (type2.isAssignableTo(type1)) continue;
            iter.remove();
        }
        return map;
    }

    @Override
    protected Annotation[] mergeAnnotations(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        return null;
    }

    @Override
    protected Map<PropertyConstant, PropertyInfo> mergeProperties(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        if (info1 == null) {
            return Collections.emptyMap();
        }
        if (info2 == null) {
            return info1.getProperties();
        }
        HashMap<PropertyConstant, PropertyInfo> map = new HashMap<PropertyConstant, PropertyInfo>();
        for (Map.Entry<String, PropertyInfo> entry : info1.ensurePropertiesByName().entrySet()) {
            String sName = entry.getKey();
            PropertyInfo prop2 = info2.findProperty(sName);
            if (prop2 != null) continue;
            PropertyInfo prop1 = entry.getValue();
            map.put(prop1.getIdentity(), prop1);
        }
        return map;
    }

    @Override
    protected Map<MethodConstant, MethodInfo> mergeMethods(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        if (info1 == null) {
            return Collections.emptyMap();
        }
        if (info2 == null) {
            return info1.getMethods();
        }
        HashMap<MethodConstant, MethodInfo> map = new HashMap<MethodConstant, MethodInfo>();
        for (Map.Entry<SignatureConstant, MethodInfo> entry : info1.ensureMethodsBySignature().entrySet()) {
            SignatureConstant sig = entry.getKey();
            MethodInfo method1 = entry.getValue();
            MethodInfo method2 = info2.getMethodBySignature(sig);
            if (method2 != null || method1.isConstructor()) continue;
            map.put(method1.getIdentity(), method1);
        }
        return map;
    }

    @Override
    protected ListMap<String, ChildInfo> mergeChildren(TypeInfo info1, TypeInfo info2, ErrorListener errs) {
        if (info1 == null) {
            return ListMap.EMPTY;
        }
        if (info2 == null) {
            return info1.getChildInfosByName();
        }
        ListMap<String, ChildInfo> map1 = info1.getChildInfosByName();
        ListMap<String, ChildInfo> map2 = info2.getChildInfosByName();
        ListMap<String, ChildInfo> mapMerge = new ListMap<String, ChildInfo>(map1);
        mapMerge.keySet().removeAll(map2.keySet());
        return mapMerge;
    }

    @Override
    protected TypeConstant.Relation calculateRelationToLeft(TypeConstant typeLeft) {
        TypeConstant typeCR;
        TypeConstant typeSubR;
        if (this.m_constType1.isFormalType() && (typeSubR = (typeCR = ((FormalConstant)this.m_constType1.getDefiningConstant()).getConstraintType()).andNot(this.getConstantPool(), this.m_constType2)) != null) {
            if (typeLeft.isFormalType()) {
                TypeConstant typeCL = ((FormalConstant)typeLeft.getDefiningConstant()).getConstraintType();
                return typeSubR.calculateRelation(typeCL);
            }
            return typeSubR.calculateRelation(typeLeft);
        }
        if (typeLeft instanceof DifferenceTypeConstant) {
            DifferenceTypeConstant typeDiff = (DifferenceTypeConstant)typeLeft;
            TypeConstant typeR1 = this.m_constType1;
            TypeConstant typeR2 = this.m_constType2;
            TypeConstant typeL1 = typeDiff.m_constType1;
            TypeConstant typeL2 = typeDiff.m_constType2;
            TypeConstant.Relation rel = typeR1.calculateRelation(typeL1);
            if (rel != TypeConstant.Relation.INCOMPATIBLE) {
                rel = rel.worseOf(typeL2.calculateRelation(typeR2));
            }
            return rel;
        }
        return TypeConstant.Relation.INCOMPATIBLE;
    }

    @Override
    protected TypeConstant.Relation calculateRelationToRight(TypeConstant typeRight) {
        TypeConstant typeR;
        TypeConstant type1 = this.m_constType1;
        if (type1 instanceof UnionTypeConstant && (typeR = this.simplifyOrClone(this.getConstantPool(), type1, this.m_constType2)) != this) {
            return typeR.calculateRelationToRight(typeRight);
        }
        return typeRight.calculateRelation(type1);
    }

    @Override
    protected TypeConstant.Relation findUnionContribution(UnionTypeConstant typeLeft) {
        return TypeConstant.Relation.INCOMPATIBLE;
    }

    @Override
    protected boolean isDuckTypeAbleFrom(TypeConstant typeRight) {
        return this.m_constType1.isInterfaceType() && this.m_constType2.equals(this.getConstantPool().typeObject());
    }

    @Override
    protected Set<SignatureConstant> isInterfaceAssignableFrom(TypeConstant typeRight, Constants.Access accessLeft, List<TypeConstant> listLeft) {
        return this.m_constType1.isInterfaceAssignableFrom(typeRight, accessLeft, listLeft);
    }

    @Override
    public boolean containsSubstitutableMethod(SignatureConstant signature, Constants.Access access, boolean fFunction, List<TypeConstant> listParams) {
        return this.m_constType1.containsSubstitutableMethod(signature, access, fFunction, listParams) && !this.m_constType2.containsSubstitutableMethod(signature, access, fFunction, listParams);
    }

    @Override
    public int callEquals(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return this.m_constType1.callEquals(frame, hValue1, hValue2, iReturn);
    }

    @Override
    public int callCompare(Frame frame, ObjectHandle hValue1, ObjectHandle hValue2, int iReturn) {
        return this.m_constType1.callCompare(frame, hValue1, hValue2, iReturn);
    }

    @Override
    public int callHashCode(Frame frame, ObjectHandle hValue, int iReturn) {
        return this.m_constType1.callHashCode(frame, hValue, iReturn);
    }

    @Override
    public MethodInfo findFunctionInfo(SignatureConstant sig) {
        return this.m_constType1.findFunctionInfo(sig);
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.DifferenceType;
    }

    @Override
    public String getValueString() {
        return this.m_constType1.getValueString() + " - " + this.m_constType2.getValueString();
    }
}

