/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.function.Consumer;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Register;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.PropertyExprAST;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.FormalTypeChildConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.ast.Context;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class DynamicFormalConstant
extends FormalConstant {
    private final int f_nReg;
    private int m_nRegId;
    private int m_iType;
    private int m_iFormal;
    private TypeConstant m_typeReg;
    private FormalConstant m_constFormal;
    private transient Register m_reg;

    public DynamicFormalConstant(ConstantPool pool, MethodConstant idMethod, String sName, Register reg, FormalConstant constFormal) {
        super(pool, idMethod, sName);
        assert (reg.getType().removeAccess().isA(constFormal.getNamespace().getType()));
        this.m_reg = reg.getOriginalRegister();
        this.m_typeReg = reg.getType();
        this.m_constFormal = constFormal;
        this.f_nReg = reg.getIndex();
    }

    public DynamicFormalConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
        this.f_nReg = Handy.readPackedInt(in);
        this.m_nRegId = Handy.readPackedInt(in);
        this.m_iType = Handy.readMagnitude(in);
        this.m_iFormal = Handy.readMagnitude(in);
    }

    @Override
    protected void resolveConstants() {
        super.resolveConstants();
        ConstantPool pool = this.getConstantPool();
        this.m_typeReg = (TypeConstant)pool.getConstant(this.m_iType);
        this.m_constFormal = (FormalConstant)pool.getConstant(this.m_iFormal);
    }

    public FormalConstant getFormalConstant() {
        return this.m_constFormal;
    }

    public Register getRegister() {
        return this.m_reg;
    }

    public int getRegisterIndex() {
        return this.m_reg == null ? this.f_nReg : this.m_reg.getIndex();
    }

    public MethodConstant getMethod() {
        return (MethodConstant)this.getParentConstant();
    }

    @Override
    public TypeConstant getConstraintType() {
        TypeConstant typeConstraint = this.m_typeReg.resolveFormalType(this.m_constFormal);
        return typeConstraint == null ? this.m_constFormal.getConstraintType().resolveConstraints() : typeConstraint;
    }

    @Override
    public ExprAST toExprAst(Context ctx) {
        if (!this.getMethod().equals(ctx.getMethod().getIdentityConstant())) {
            return null;
        }
        FormalConstant constFormal = this.getFormalConstant();
        LinkedList<FormalTypeChildConstant> listNames = null;
        while (constFormal instanceof FormalTypeChildConstant) {
            FormalTypeChildConstant idChild = (FormalTypeChildConstant)constFormal;
            if (listNames == null) {
                listNames = new LinkedList<FormalTypeChildConstant>();
            }
            listNames.addFirst(idChild);
            constFormal = idChild.getParentConstant();
        }
        if (constFormal instanceof PropertyConstant) {
            PropertyConstant idProp = (PropertyConstant)constFormal;
            PropertyExprAST astExpr = new PropertyExprAST(this.getRegister().getRegisterAST(), idProp);
            if (listNames != null) {
                for (FormalTypeChildConstant idNext : listNames) {
                    astExpr = new PropertyExprAST(astExpr, idNext);
                }
            }
            return astExpr;
        }
        throw new IllegalStateException("Unsupported formal: " + String.valueOf(constFormal));
    }

    @Override
    public IdentityConstant replaceParentConstant(IdentityConstant idParent) {
        return new DynamicFormalConstant(this.getConstantPool(), (MethodConstant)idParent, this.getName(), this.getRegister(), this.getFormalConstant());
    }

    @Override
    public IdentityConstant appendTrailingSegmentTo(IdentityConstant that) {
        throw new IllegalStateException();
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.DynamicFormal;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.m_constFormal);
    }

    @Override
    public boolean containsUnresolved() {
        return !this.isHashCached() && (super.containsUnresolved() || this.m_typeReg.containsUnresolved() || this.m_constFormal.containsUnresolved());
    }

    @Override
    public String getValueString() {
        return this.getName() + "." + this.m_constFormal.getName();
    }

    @Override
    public String getDescription() {
        return "Dynamic " + this.getValueString();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        super.registerConstants(pool);
        this.m_typeReg = (TypeConstant)pool.register(this.m_typeReg);
        this.m_constFormal = (FormalConstant)pool.register(this.m_constFormal);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        super.assemble(out);
        if (this.m_reg == null) {
            Handy.writePackedLong(out, this.f_nReg);
            Handy.writePackedLong(out, this.m_nRegId);
        } else {
            assert (!this.m_reg.isUnknown());
            Handy.writePackedLong(out, this.m_reg.getIndex());
            Handy.writePackedLong(out, this.m_reg.getId());
        }
        Handy.writePackedLong(out, this.m_typeReg.getPosition());
        Handy.writePackedLong(out, this.m_constFormal.getPosition());
    }

    @Override
    protected int compareDetails(Constant obj) {
        if (!(obj instanceof DynamicFormalConstant)) {
            return -1;
        }
        DynamicFormalConstant that = (DynamicFormalConstant)obj;
        int n = super.compareDetails(that);
        if (n != 0) {
            return n;
        }
        n = this.m_constFormal.compareDetails(that.m_constFormal);
        if (n != 0) {
            return n;
        }
        n = this.m_typeReg.compareTo(that.m_typeReg);
        if (n != 0) {
            return n;
        }
        if (this.m_reg == null) {
            return that.m_reg == null ? this.f_nReg - that.f_nReg | this.m_nRegId - that.m_nRegId : -1;
        }
        return that.m_reg == null ? 1 : (this.m_reg == that.m_reg ? 0 : -1);
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_constFormal, Hash.of(this.m_typeReg, super.computeHashCode()));
    }
}

