/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.compiler.Token;
import org.xvm.util.PackedInteger;

public class EnumValueConstant
extends SingletonConstant {
    public EnumValueConstant(ConstantPool pool, ClassConstant constClass) {
        super(pool, Constant.Format.EnumValueConst, constClass);
        if (constClass.getComponent().getFormat() != Component.Format.ENUMVALUE) {
            throw new IllegalArgumentException("enum value required");
        }
    }

    public EnumValueConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        super(pool, format, in);
    }

    public int getPresumedOrdinal() {
        ClassStructure clzThis = (ClassStructure)this.getClassConstant().getComponent();
        int nOrdinal = 0;
        for (Component component : clzThis.getParent().children()) {
            if (component.getFormat() != Component.Format.ENUMVALUE) continue;
            if (component == clzThis) {
                return nOrdinal;
            }
            ++nOrdinal;
        }
        return -1;
    }

    @Override
    public Constant getValue() {
        int iOrdinal = this.getPresumedOrdinal();
        return iOrdinal < 0 ? null : this.getConstantPool().ensureIntConstant(iOrdinal);
    }

    @Override
    public EnumValueConstant resolveTypedefs() {
        ClassConstant constOld = (ClassConstant)this.getClassConstant();
        ClassConstant constNew = (ClassConstant)constOld.resolveTypedefs();
        return constNew == constOld ? this : (EnumValueConstant)this.getConstantPool().register(new EnumValueConstant(this.getConstantPool(), constNew));
    }

    @Override
    public PackedInteger getIntValue() {
        int iOrdinal = this.getPresumedOrdinal();
        return iOrdinal >= 0 ? new PackedInteger(iOrdinal) : super.getIntValue();
    }

    @Override
    public Constant apply(Token.Id op, Constant that) {
        ConstantPool pool = this.getConstantPool();
        if (that instanceof EnumValueConstant) {
            switch (op) {
                case I_RANGE_I: {
                    return pool.ensureRangeConstant(this, that);
                }
                case E_RANGE_I: {
                    return pool.ensureRangeConstant(this, true, that, false);
                }
                case I_RANGE_E: {
                    return pool.ensureRangeConstant(this, false, that, true);
                }
                case E_RANGE_E: {
                    return pool.ensureRangeConstant(this, true, that, true);
                }
                case SUB: {
                    return pool.ensureIntConstant(this.getPresumedOrdinal() - ((EnumValueConstant)that).getPresumedOrdinal());
                }
                case COMP_EQ: {
                    return pool.valOf(this.getPresumedOrdinal() == ((EnumValueConstant)that).getPresumedOrdinal());
                }
                case COMP_NEQ: {
                    return pool.valOf(this.getPresumedOrdinal() != ((EnumValueConstant)that).getPresumedOrdinal());
                }
                case COMP_LT: {
                    return pool.valOf(this.getPresumedOrdinal() < ((EnumValueConstant)that).getPresumedOrdinal());
                }
                case COMP_LTEQ: {
                    return pool.valOf(this.getPresumedOrdinal() <= ((EnumValueConstant)that).getPresumedOrdinal());
                }
                case COMP_GT: {
                    return pool.valOf(this.getPresumedOrdinal() > ((EnumValueConstant)that).getPresumedOrdinal());
                }
                case COMP_GTEQ: {
                    return pool.valOf(this.getPresumedOrdinal() >= ((EnumValueConstant)that).getPresumedOrdinal());
                }
            }
        } else if (that == null && op == Token.Id.NOT) {
            if (this.getClassConstant().equals(pool.valTrue().getClassConstant())) {
                return pool.valFalse();
            }
            if (this.getClassConstant().equals(pool.valFalse().getClassConstant())) {
                return pool.valTrue();
            }
        }
        switch (op) {
            case ADD: {
                assert (that.equals(pool.ensureLiteralConstant(Constant.Format.IntLiteral, "1")));
                ClassStructure clzValue = (ClassStructure)this.getClassConstant().getComponent();
                ClassStructure clzEnum = (ClassStructure)clzValue.getParent();
                boolean fNext = false;
                for (Component component : clzEnum.children()) {
                    if (fNext) {
                        ClassStructure clzChild;
                        if (!(component instanceof ClassStructure) || (clzChild = (ClassStructure)component).getFormat() != Component.Format.ENUMVALUE) continue;
                        return pool.ensureSingletonConstConstant(clzChild.getIdentityConstant());
                    }
                    if (component != clzValue) continue;
                    fNext = true;
                }
                return null;
            }
            case SUB: {
                assert (that.equals(pool.ensureLiteralConstant(Constant.Format.IntLiteral, "1")));
                ClassStructure clzValue = (ClassStructure)this.getClassConstant().getComponent();
                ClassStructure clzEnum = (ClassStructure)clzValue.getParent();
                Component clzPrev = null;
                for (Component component : clzEnum.children()) {
                    ClassStructure clzChild;
                    if (component == clzValue) {
                        return clzPrev == null ? null : pool.ensureSingletonConstConstant(clzPrev.getIdentityConstant());
                    }
                    if (!(component instanceof ClassStructure) || (clzChild = (ClassStructure)component).getFormat() != Component.Format.ENUMVALUE) continue;
                    clzPrev = clzChild;
                }
                return null;
            }
        }
        return super.apply(op, that);
    }

    @Override
    public String getDescription() {
        return "enum=" + this.getClassConstant().getName();
    }
}

