/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.compiler.ast.Expression;
import org.xvm.util.Hash;

public class ExpressionConstant
extends PseudoConstant {
    private final transient Expression m_expr;

    public ExpressionConstant(ConstantPool pool, Expression expr) {
        super(pool);
        this.m_expr = expr;
    }

    public Expression getExpression() {
        return this.m_expr;
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.DeferredValue;
    }

    @Override
    public boolean containsUnresolved() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof ExpressionConstant)) return -1;
        ExpressionConstant exprThat = (ExpressionConstant)that;
        if (!this.m_expr.equals(exprThat.m_expr)) return -1;
        return 0;
    }

    @Override
    public String getValueString() {
        return this.m_expr.toString();
    }

    @Override
    public String getDescription() {
        return "expression=" + String.valueOf(this.m_expr);
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_expr);
    }
}

