/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.constants.ValueConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;

public class FPNConstant
extends ValueConstant {
    private final Constant.Format m_fmt;
    private final byte[] m_abVal;

    public FPNConstant(ConstantPool pool, Constant.Format format, DataInput in) throws IOException {
        this(pool, format, FPNConstant.readVarBytes(in));
    }

    public FPNConstant(ConstantPool pool, Constant.Format format, byte[] abVal) {
        super(pool);
        if (format == null) {
            throw new IllegalStateException("format required");
        }
        int cbMin = switch (format) {
            case Constant.Format.DecN -> 4;
            case Constant.Format.FloatN -> 2;
            default -> throw new IllegalStateException("unsupported format: " + String.valueOf((Object)format));
        };
        if (abVal == null) {
            throw new IllegalArgumentException("value required");
        }
        int cbVal = abVal.length;
        if (cbVal < cbMin || cbVal > 16384 || Integer.bitCount(cbVal) != 1) {
            throw new IllegalArgumentException("value length (" + cbVal + ") must be a power-of-two between " + cbMin + " and 16384");
        }
        this.m_fmt = format;
        this.m_abVal = abVal;
    }

    private static byte[] readVarBytes(DataInput in) throws IOException {
        int cb = 1 << in.readUnsignedByte();
        byte[] ab = new byte[cb];
        in.readFully(ab);
        return ab;
    }

    public byte[] getValue() {
        return this.m_abVal;
    }

    @Override
    public Constant.Format getFormat() {
        return this.m_fmt;
    }

    @Override
    protected int compareDetails(Constant that) {
        if (!(that instanceof FPNConstant)) {
            return -1;
        }
        byte[] abThis = this.m_abVal;
        int cbThis = abThis.length;
        byte[] abThat = ((FPNConstant)that).m_abVal;
        int cbThat = abThat.length;
        if (cbThis != cbThat) {
            return cbThis - cbThat;
        }
        for (int of = 0; of < cbThis; ++of) {
            if (abThis[of] == abThat[of]) continue;
            return (abThis[of] & 0xFF) - (abThat[of] & 0xFF);
        }
        return 0;
    }

    @Override
    public String getValueString() {
        return "(unsupported)";
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        out.writeByte(Integer.numberOfTrailingZeros(Integer.highestOneBit(this.m_abVal.length)));
        out.write(this.m_abVal);
    }

    @Override
    public String getDescription() {
        return "bytes=" + Handy.byteArrayToHexString(this.m_abVal);
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_abVal);
    }
}

